/*
 * Decompiled with CFR 0.152.
 */
package shohaku.kosho;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import shohaku.core.collections.IteratorUtils;
import shohaku.ginkgo.Ginkgo;
import shohaku.ginkgo.GinkgoException;
import shohaku.ginkgo.Node;
import shohaku.ginkgo.NodeCompositeRule;
import shohaku.kosho.Kosho;
import shohaku.kosho.KoshoResources;
import shohaku.kosho.KoshoResourcesLoader;

public class ClassMappingConfiguration
implements KoshoResourcesLoader {
    private final Map lookup = new Hashtable();
    private final Ginkgo ginkgo = new Ginkgo();
    private ClassLoader classLoader;
    static /* synthetic */ Class class$0;

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void load(InputStream inStream) throws GinkgoException {
        this.load(inStream, ClassMappingConfiguration.getDefaultNodeCompositeRule());
    }

    public void load(InputStream inStream, NodeCompositeRule rule) throws GinkgoException {
        this.ginkgo.parse(rule, inStream);
        Node root = this.ginkgo.getDocument().getContext().getRoot();
        this.initValues(root);
    }

    private void initValues(Node root) {
        HashMap<String, ConfigurationResourcesImpl> m = new HashMap<String, ConfigurationResourcesImpl>();
        Iterator i = root.getContext().elementIterator("class");
        while (i.hasNext()) {
            Node classNode = (Node)i.next();
            String className = classNode.getAttribute("name");
            if (className == null || className.length() == 0) {
                throw new GinkgoException("class name isn't specified.");
            }
            ConfigurationResourcesImpl resources = this.getClassResources(classNode);
            m.put(className, resources);
        }
        this.lookup.putAll(m);
    }

    private ConfigurationResourcesImpl getClassResources(Node classNode) {
        HashMap m = new HashMap();
        this.initClassResources(classNode, "", m, '.');
        return new ConfigurationResourcesImpl(m);
    }

    private void initClassResources(Node parent, String parentName, Map m, char separator) {
        Iterator i = parent.getContext().ownerIterator();
        while (i.hasNext()) {
            String name;
            Node n = (Node)i.next();
            if (n.isType(3)) {
                name = n.getAttribute("name");
                if (name == null || name.length() == 0) continue;
                m.put(String.valueOf(parentName) + name, n.getNodeValue());
                continue;
            }
            if (!n.isType(1)) continue;
            if ("constants".equals(n.getContext().getNodeName())) {
                this.initClassResources(n, parentName, m, '_');
                continue;
            }
            name = n.getAttribute("name");
            if (name == null || name.length() == 0) continue;
            this.initClassResources(n, String.valueOf(parentName) + name + separator, m, separator);
        }
    }

    public KoshoResources getResources(Class key) {
        if (key == null) {
            throw new NullPointerException("resource key is null");
        }
        return (KoshoResources)this.lookup.get(key.getName());
    }

    public KoshoResources getResources(String className) {
        if (className == null) {
            throw new NullPointerException("className is null");
        }
        return (KoshoResources)this.lookup.get(className);
    }

    public boolean containsClass(Class key) {
        if (key == null) {
            throw new NullPointerException("resource key is null");
        }
        return this.lookup.containsKey(key.getName());
    }

    public Iterator classNameIterator() {
        return IteratorUtils.unmodifiableIterator(this.lookup.keySet().iterator());
    }

    public Iterator resourceIterator() {
        return IteratorUtils.unmodifiableIterator(this.lookup.values().iterator());
    }

    public static NodeCompositeRule getDefaultNodeCompositeRule() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("shohaku.kosho.ClassMappingConfiguration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return Kosho.getDefaultNodeCompositeRule(clazz);
    }

    private static class ConfigurationResourcesImpl
    implements KoshoResources {
        private final Map src;

        ConfigurationResourcesImpl(Map resources) {
            this.src = resources;
        }

        public Iterator keyIterator() {
            return IteratorUtils.unmodifiableIterator(this.src.keySet().iterator());
        }

        public Object getObject(String key) {
            if (key == null) {
                throw new NullPointerException("resource key is null");
            }
            return this.src.get(key);
        }

        public Object getObject(String key, Object defaultValue) {
            if (key == null) {
                throw new NullPointerException("resource key is null");
            }
            return this.getObject(key, defaultValue);
        }

        public boolean containsKey(String key) {
            if (key == null) {
                throw new NullPointerException("resource key is null");
            }
            return this.src.containsKey(key);
        }

        public boolean containsKey(String key, Class type) {
            if (key == null || type == null) {
                throw new NullPointerException("resource key or resource type is null");
            }
            Object o = this.getObject(key);
            if (o != null) {
                return type.isInstance(o);
            }
            return this.containsKey(key);
        }
    }
}

