/*
 * Decompiled with CFR 0.152.
 */
package shohaku.kosho;

import java.io.InputStream;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import shohaku.core.collections.Entry;
import shohaku.core.collections.EntryUtils;
import shohaku.core.lang.NoSuchResourceException;
import shohaku.core.lang.ResourceLoader;
import shohaku.ginkgo.NodeCompositeRule;
import shohaku.kosho.ClassBindConfiguration;
import shohaku.kosho.ClassMappingConfiguration;
import shohaku.kosho.KoshoHelper;
import shohaku.kosho.KoshoResources;
import shohaku.kosho.XMLLocaleResourceBundle;
import shohaku.kosho.XMLProperties;

public class Kosho {
    static /* synthetic */ Class class$0;

    public static KoshoResources getXMLProperties(String path) throws NoSuchResourceException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("shohaku.kosho.Kosho");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return Kosho.getXMLProperties(path, clazz.getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KoshoResources getXMLProperties(String path, ClassLoader loader) throws NoSuchResourceException {
        Map map = Cache.xmlProperties;
        synchronized (map) {
            KoshoResources resources = (KoshoResources)Cache.xmlProperties.get(path);
            if (resources == null) {
                resources = Kosho.loadXMLProperties(path, loader);
                Cache.xmlProperties.put(path, resources);
            }
            return resources;
        }
    }

    private static KoshoResources loadXMLProperties(String path, ClassLoader loader) throws NoSuchResourceException {
        InputStream inStream = ResourceLoader.getResourceAsStream((String)path, (ClassLoader)loader);
        XMLProperties resources = new XMLProperties();
        resources.setClassLoader(loader);
        resources.load(inStream);
        return resources;
    }

    public static KoshoResources getXMLLocaleResourceBundle(String baseName) {
        return XMLLocaleResourceBundle.getBundle(baseName);
    }

    public static KoshoResources getXMLLocaleResourceBundle(String baseName, Locale locale) {
        return XMLLocaleResourceBundle.getBundle(baseName, locale);
    }

    public static KoshoResources getXMLLocaleResourceBundle(String baseName, Locale locale, ClassLoader loader) {
        return XMLLocaleResourceBundle.getBundle(baseName, locale, loader);
    }

    public static KoshoResources getClassBindConfiguration(Class key) throws NoSuchResourceException {
        return Kosho.getClassBindConfiguration(key, key.getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KoshoResources getClassBindConfiguration(Class key, ClassLoader loader) throws NoSuchResourceException {
        Map map = Cache.classBindConfiguration;
        synchronized (map) {
            KoshoResources resources = (KoshoResources)Cache.classBindConfiguration.get(key);
            if (resources == null) {
                resources = Kosho.loadClassBindConfiguration(key, loader);
                Cache.classBindConfiguration.put(key, resources);
            }
            return resources;
        }
    }

    private static KoshoResources loadClassBindConfiguration(Class key, ClassLoader loader) throws NoSuchResourceException {
        String resource = String.valueOf(key.getName().replace('.', '/')) + "-config.xml";
        ClassBindConfiguration classBindConfig = new ClassBindConfiguration();
        InputStream inStream = ResourceLoader.getResourceAsStream((String)resource, (ClassLoader)loader);
        classBindConfig.load(inStream);
        return classBindConfig;
    }

    public static KoshoResources getClassMappingConfiguration(String path, Class key) throws NoSuchResourceException {
        return Kosho.getClassMappingConfiguration(path, key, key.getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KoshoResources getClassMappingConfiguration(String path, Class key, ClassLoader loader) throws NoSuchResourceException {
        Map map = Cache.classConfiguration;
        synchronized (map) {
            Entry entry = EntryUtils.arrayEntry((Object[])new Object[]{path, key.getName()});
            KoshoResources resources = (KoshoResources)Cache.classConfiguration.get(entry);
            if (resources == null) {
                Kosho.loadClassMappingConfiguration(path, loader);
                resources = (KoshoResources)Cache.classConfiguration.get(entry);
            }
            if (resources == null) {
                throw new NoSuchResourceException("no such configuration resource. class:" + key + ", path:" + path);
            }
            return resources;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadClassMappingConfiguration(String path, ClassLoader loader) throws NoSuchResourceException {
        InputStream inStream = ResourceLoader.getResourceAsStream((String)path, (ClassLoader)loader);
        ClassMappingConfiguration classConfiguration = new ClassMappingConfiguration();
        classConfiguration.load(inStream);
        Map map = Cache.classConfiguration;
        synchronized (map) {
            Iterator i = classConfiguration.classNameIterator();
            while (i.hasNext()) {
                String className = (String)i.next();
                Entry entry = EntryUtils.arrayEntry((Object[])new Object[]{path, className});
                Cache.classConfiguration.put(entry, classConfiguration.getResources(className));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NodeCompositeRule getDefaultNodeCompositeRule(Class c) {
        Map map = Cache.defaultNodeCompositeRule;
        synchronized (map) {
            NodeCompositeRule rule = (NodeCompositeRule)Cache.defaultNodeCompositeRule.get(c);
            if (rule == null) {
                rule = KoshoHelper.loadDefaultNodeCompositeRule(c, c.getClassLoader());
                Cache.defaultNodeCompositeRule.put(c, rule);
            }
            return rule;
        }
    }

    private static final class Cache {
        public static final Map classBindConfiguration = new IdentityHashMap();
        public static final Map xmlProperties = new HashMap();
        public static final Map classConfiguration = new HashMap();
        public static final Map defaultNodeCompositeRule = new IdentityHashMap();

        Cache() {
        }
    }
}

