/*
 * Decompiled with CFR 0.152.
 */
package shohaku.kosho;

import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import shohaku.core.helpers.Eval;
import shohaku.ginkgo.Document;
import shohaku.ginkgo.DocumentCompositeRule;
import shohaku.ginkgo.Ginkgo;
import shohaku.ginkgo.GinkgoException;
import shohaku.ginkgo.Node;
import shohaku.ginkgo.NodeCompositeRule;
import shohaku.kosho.Kosho;
import shohaku.kosho.KoshoResources;
import shohaku.kosho.KoshoResourcesLoader;

public class XMLProperties
implements KoshoResources,
KoshoResourcesLoader {
    private final Map lookup;
    private final Map unmodifiableLookup;
    private final Ginkgo ginkgo;
    private ClassLoader classLoader;
    static /* synthetic */ Class class$0;

    public XMLProperties() {
        this.ginkgo = new Ginkgo();
        this.lookup = new LinkedHashMap();
        this.unmodifiableLookup = Collections.unmodifiableMap(this.lookup);
    }

    public XMLProperties(DocumentCompositeRule docRule) {
        this.ginkgo = new Ginkgo(docRule);
        this.lookup = new LinkedHashMap();
        this.unmodifiableLookup = Collections.unmodifiableMap(this.lookup);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public synchronized void load(InputStream inStream) throws GinkgoException {
        this.load(inStream, XMLProperties.getDefaultNodeCompositeRule());
    }

    public synchronized void load(InputStream inStream, Document content) throws GinkgoException {
        this.load(inStream, XMLProperties.getDefaultNodeCompositeRule(), content);
    }

    public synchronized void load(InputStream inStream, NodeCompositeRule rule) throws GinkgoException {
        this.load(inStream, rule, null);
    }

    public synchronized void load(InputStream inStream, NodeCompositeRule rule, Document content) throws GinkgoException {
        this.ginkgo.parse(rule, inStream, content);
        Node root = this.ginkgo.getDocument().getContext().getRoot();
        this.initValues(root);
    }

    private void initValues(Node root) {
        Iterator i = root.getContext().elementIterator("content");
        if (i.hasNext()) {
            Node content = (Node)i.next();
            this.initValues(content, content);
        }
    }

    private void initValues(Node root, Node content) {
        Iterator i = content.getContext().ownerIterator();
        while (i.hasNext()) {
            String path;
            Node n = (Node)i.next();
            if (n.isType(1)) {
                this.initValues(root, n);
                continue;
            }
            if (!n.isType(3) || (path = this.getPath(root, n)) == null) continue;
            this.saveValue(path, n);
        }
    }

    private void saveValue(Object path, Node node) {
        this.lookup.put(path, node.getNodeValue());
    }

    private String getPath(Node root, Node node) {
        StringBuffer sb = new StringBuffer(80);
        Node c = node;
        while (c != root && c != null) {
            String name = this.getNodeName(c);
            if (Eval.isBlank((CharSequence)name)) {
                return null;
            }
            sb.insert(0, name);
            sb.insert(0, '/');
            c = c.getContext().getParent();
        }
        if (node.isType(1)) {
            sb.append('/');
        }
        return sb.toString();
    }

    private String getNodeName(Node node) {
        String name = null;
        if (!node.isType(2)) {
            name = node.getAttribute("name");
            if (Eval.isBlank((CharSequence)name)) {
                name = null;
            }
        } else {
            name = "#TEXT#";
        }
        return name;
    }

    public Document getDocument() {
        return this.ginkgo.getDocument();
    }

    public Map toMap() {
        return this.unmodifiableLookup;
    }

    public Set getNames() {
        return this.unmodifiableLookup.keySet();
    }

    public Iterator keyIterator() {
        return this.getNames().iterator();
    }

    public Object getObject(String key) {
        if (key == null) {
            throw new NullPointerException("resource key as null");
        }
        Object obj = this.lookup.get(key);
        return obj;
    }

    public Object getObject(String key, Object defaultValue) {
        Object o = this.getObject(key);
        if (o == null) {
            o = defaultValue;
        }
        return o;
    }

    public boolean containsKey(String key) {
        if (key == null) {
            throw new NullPointerException("resource key as null");
        }
        return this.lookup.containsKey(key);
    }

    public boolean containsKey(String key, Class type) {
        if (Eval.isOrNull((Object)key, (Object)type)) {
            throw new NullPointerException("resource key or type as null");
        }
        Object o = this.getObject(key);
        if (o != null) {
            return type.isInstance(o);
        }
        return this.containsKey(key);
    }

    public static NodeCompositeRule getDefaultNodeCompositeRule() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("shohaku.kosho.XMLProperties");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return Kosho.getDefaultNodeCompositeRule(clazz);
    }
}

