/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.beans;

import shohaku.core.beans.ClassInfo;
import shohaku.core.beans.InvocationBeansException;
import shohaku.core.beans.ObjectGenerator;
import shohaku.core.helpers.Eval;
import shohaku.core.lang.ObjectCreationException;

public class BeansFactory
implements ObjectGenerator {
    public static final String SINGLETON = "singleton";
    public static final String PROTOTYPE = "prototype";
    private Object cache;
    private final String type;
    private final ClassInfo classInfo;
    private final Class createSourceType;
    static /* synthetic */ Class class$0;

    public BeansFactory(ClassInfo classInfo, Class createSourceType) {
        this(classInfo, createSourceType, PROTOTYPE);
    }

    public BeansFactory(ClassInfo classInfo, Class createSourceType, String type) {
        if (Eval.isOrNull(classInfo, createSourceType, type)) {
            throw new NullPointerException("argument is null.");
        }
        if (!Eval.isContains(this.getFactoryTypes(), (Object)type)) {
            throw new IllegalArgumentException("type:" + type);
        }
        this.classInfo = classInfo;
        this.createSourceType = createSourceType;
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public ClassInfo getClassInfo() {
        return this.classInfo;
    }

    public Class getCreateSourceType() {
        return this.createSourceType;
    }

    public Object getInstance() throws ObjectCreationException {
        return this.createObject();
    }

    public Class getInstanceType() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object createObject() throws ObjectCreationException {
        try {
            if (SINGLETON.equals(this.getType())) {
                BeansFactory beansFactory = this;
                synchronized (beansFactory) {
                    if (this.getCache() == null) {
                        this.setCache(this.getClassInfo().newInstance(this.getCreateSourceType()));
                    }
                    return this.getCache();
                }
            }
            if (PROTOTYPE.equals(this.getType())) {
                return this.getClassInfo().newInstance(this.getCreateSourceType());
            }
            throw new ObjectCreationException("instance type is illegal. type:" + this.getType());
        }
        catch (InvocationBeansException e) {
            throw new ObjectCreationException("ClassInfo:" + this.getClassInfo() + ", type:" + this.getType(), e);
        }
    }

    protected String[] getFactoryTypes() {
        return new String[]{PROTOTYPE, SINGLETON};
    }

    protected synchronized Object getCache() {
        return this.cache;
    }

    protected synchronized void setCache(Object instance) {
        this.cache = instance;
    }
}

