/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.collections.wrapper;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import shohaku.core.collections.Group;
import shohaku.core.collections.wrapper.UnmodifiableCollection;
import shohaku.core.collections.wrapper.UnmodifiableIterator;
import shohaku.core.collections.wrapper.UnmodifiableSet;
import shohaku.core.collections.wrapper.WrappedGroup;

public class UnmodifiableGroup
extends WrappedGroup {
    private static final long serialVersionUID = 571658727084149157L;

    public UnmodifiableGroup(Group g) {
        super(g);
    }

    public Collection get(Object key) {
        Collection c = this.group.get(key);
        return c != null ? new UnmodifiableCollection(c) : null;
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new UnmodifiableSet(this.group.keySet());
        }
        return this.keySet;
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new UnmodifiableEntrySet(this.group.entrySet());
        }
        return this.entrySet;
    }

    public Iterator iterator() {
        return new UnmodifiableIterator(this.group.iterator());
    }

    public Iterator iterator(Object key) {
        return new UnmodifiableIterator(this.group.iterator(key));
    }

    public boolean add(Object key) {
        throw new UnsupportedOperationException();
    }

    public boolean add(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    public void addAll(Group g) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(Object key, Collection c) {
        throw new UnsupportedOperationException();
    }

    public Collection remove(Object key) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    protected class UnmodifiableEntrySet
    extends UnmodifiableSet {
        private static final long serialVersionUID = 9180097280351929109L;

        protected UnmodifiableEntrySet(Set s) {
            super(s);
        }

        public Iterator iterator() {
            return this.wrappedIterator(this.coll.iterator());
        }

        public Object[] toArray() {
            Object[] a = this.coll.toArray();
            int i = 0;
            while (i < a.length) {
                a[i] = this.wrappedEntry((Group.Entry)a[i]);
                ++i;
            }
            return a;
        }

        public Object[] toArray(Object[] a) {
            Object[] arr = this.coll.toArray(a.length == 0 ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), 0));
            int i = 0;
            while (i < arr.length) {
                arr[i] = this.wrappedEntry((Group.Entry)arr[i]);
                ++i;
            }
            if (arr.length > a.length) {
                return arr;
            }
            System.arraycopy(arr, 0, a, 0, arr.length);
            if (a.length > arr.length) {
                a[arr.length] = null;
            }
            return a;
        }

        public boolean contains(Object o) {
            if (!(o instanceof Group.Entry)) {
                return false;
            }
            return this.coll.contains(this.wrappedEntry((Group.Entry)o));
        }

        public boolean containsAll(Collection coll) {
            Iterator e = coll.iterator();
            while (e.hasNext()) {
                if (this.contains(e.next())) continue;
                return false;
            }
            return true;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Set)) {
                return false;
            }
            Set s = (Set)o;
            if (s.size() != this.coll.size()) {
                return false;
            }
            return this.containsAll((Collection)s);
        }

        protected Iterator wrappedIterator(Iterator iterator) {
            return new UnmodifiableIterator(this, iterator){
                final /* synthetic */ UnmodifiableEntrySet this$1;
                {
                    this.this$1 = unmodifiableEntrySet;
                }

                public Object next() {
                    return this.this$1.wrappedEntry((Group.Entry)super.next());
                }
            };
        }

        protected Group.Entry wrappedEntry(Group.Entry entry) {
            return new UnmodifiableEntry(entry);
        }
    }

    protected class UnmodifiableEntry
    extends WrappedGroup.WrappedGroupEntry {
        protected UnmodifiableEntry(Group.Entry e) {
            super(UnmodifiableGroup.this, e);
        }

        public Collection getValues() {
            return new UnmodifiableCollection(this.e.getValues());
        }
    }
}

