/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.collections.wrapper;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import shohaku.core.collections.wrapper.WrappedCollection;
import shohaku.core.collections.wrapper.WrappedIterator;
import shohaku.core.collections.wrapper.WrappedSet;

public class WrappedMap
implements Map,
Serializable {
    private static final long serialVersionUID = -5236450138696957592L;
    protected final Map map;

    public WrappedMap(Map m) {
        if (m == null) {
            throw new NullPointerException();
        }
        this.map = m;
    }

    public int size() {
        return this.map.size();
    }

    public void clear() {
        this.map.clear();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    public Collection values() {
        return new WrappedCollection(this.map.values());
    }

    public void putAll(Map m) {
        this.map.putAll(m);
    }

    public Set entrySet() {
        return new WrappedMapEntrySet(this.map.entrySet());
    }

    public Set keySet() {
        return new WrappedSet(this.map.keySet());
    }

    public Object get(Object key) {
        return this.map.get(key);
    }

    public Object remove(Object key) {
        return this.map.remove(key);
    }

    public Object put(Object key, Object value) {
        return this.map.put(key, value);
    }

    public boolean equals(Object o) {
        return this.map.equals(o);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }

    protected class WrappedMapEntrySet
    extends WrappedSet {
        private static final long serialVersionUID = -6312088883403883920L;

        protected WrappedMapEntrySet(Set s) {
            super(s);
        }

        public Iterator iterator() {
            return new WrappedIterator(this, this.set.iterator()){
                final /* synthetic */ WrappedMapEntrySet this$1;
                {
                    this.this$1 = wrappedMapEntrySet;
                }

                public Object next() {
                    return WrappedMapEntrySet.access$0(this.this$1).new WrappedMapEntry((Map.Entry)this.i.next());
                }
            };
        }

        public Object[] toArray() {
            Object[] a = this.set.toArray();
            int i = 0;
            while (i < a.length) {
                a[i] = new WrappedMapEntry((Map.Entry)a[i]);
                ++i;
            }
            return a;
        }

        public Object[] toArray(Object[] a) {
            Object[] arr = this.coll.toArray(a.length == 0 ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), 0));
            int i = 0;
            while (i < arr.length) {
                arr[i] = new WrappedMapEntry((Map.Entry)arr[i]);
                ++i;
            }
            if (arr.length > a.length) {
                return arr;
            }
            System.arraycopy(arr, 0, a, 0, arr.length);
            if (a.length > arr.length) {
                a[arr.length] = null;
            }
            return a;
        }

        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            return this.set.contains(new WrappedMapEntry((Map.Entry)o));
        }

        public boolean containsAll(Collection coll) {
            Iterator e = coll.iterator();
            while (e.hasNext()) {
                if (this.contains(e.next())) continue;
                return false;
            }
            return true;
        }

        static /* synthetic */ WrappedMap access$0(WrappedMapEntrySet wrappedMapEntrySet) {
            return wrappedMapEntrySet.WrappedMap.this;
        }
    }

    protected class WrappedMapEntry
    implements Map.Entry {
        protected Map.Entry e;

        protected WrappedMapEntry(Map.Entry e) {
            this.e = e;
        }

        public Object getKey() {
            return this.e.getKey();
        }

        public Object getValue() {
            return this.e.getValue();
        }

        public Object setValue(Object value) {
            return this.e.setValue(value);
        }

        public int hashCode() {
            return this.e.hashCode();
        }

        public boolean equals(Object o) {
            return this.e.equals(o);
        }

        public String toString() {
            return this.e.toString();
        }
    }
}

