/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.helpers;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import shohaku.core.collections.Group;
import shohaku.core.collections.params.Parameters;
import shohaku.core.helpers.Cutter;
import shohaku.core.helpers.Seek;

public class Eval {
    public static boolean isBlank(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isAndBlank(CharSequence cs1, CharSequence cs2) {
        return Eval.isBlank(cs1) && Eval.isBlank(cs2);
    }

    public static boolean isAndBlank(CharSequence[] css) {
        int i = 0;
        while (i < css.length) {
            if (!Eval.isBlank(css[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isOrBlank(CharSequence cs1, CharSequence cs2) {
        return Eval.isBlank(cs1) || Eval.isBlank(cs2);
    }

    public static boolean isOrBlank(CharSequence[] css) {
        int i = 0;
        while (i < css.length) {
            if (Eval.isBlank(css[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isBlankOrSpace(CharSequence cs) {
        return cs == null || Cutter.trim(cs).length() == 0;
    }

    public static boolean isAndBlankOrSpace(CharSequence cs1, CharSequence cs2) {
        return Eval.isBlankOrSpace(cs1) && Eval.isBlankOrSpace(cs2);
    }

    public static boolean isAndBlankOrSpace(CharSequence[] css) {
        int i = 0;
        while (i < css.length) {
            if (!Eval.isBlankOrSpace(css[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isOrBlankOrSpace(CharSequence cs1, CharSequence cs2) {
        return Eval.isBlankOrSpace(cs1) || Eval.isBlankOrSpace(cs2);
    }

    public static boolean isOrBlankOrSpace(CharSequence[] css) {
        int i = 0;
        while (i < css.length) {
            if (Eval.isBlankOrSpace(css[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isEmpty(Object[] os) {
        return os == null || os.length == 0;
    }

    public static boolean isEmpty(Map m) {
        return m == null || m.isEmpty();
    }

    public static boolean isEmpty(Collection c) {
        return c == null || c.isEmpty();
    }

    public static boolean isEmpty(Group g) {
        return g == null || g.isEmpty();
    }

    public static boolean isEmpty(Parameters p) {
        return p == null || p.isEmpty();
    }

    public static boolean isAndNull(Object o1, Object o2) {
        return o1 == null && o2 == null;
    }

    public static boolean isAndNull(Object[] os) {
        int i = 0;
        while (i < os.length) {
            if (os[i] != null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isOrNull(Object o1, Object o2) {
        return o1 == null || o2 == null;
    }

    public static boolean isOrNull(Object o1, Object o2, Object o3) {
        return o1 == null || o2 == null || o3 == null;
    }

    public static boolean isOrNull(Object o1, Object o2, Object o3, Object o4) {
        return o1 == null || o2 == null || o3 == null || o4 == null;
    }

    public static boolean isOrNull(Object[] os) {
        int i = 0;
        while (i < os.length) {
            if (os[i] == null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isEquals(Object o, Object o2) {
        if (o == o2) {
            return true;
        }
        return o != null && o.equals(o2);
    }

    public static boolean isOrEquals(Object o, Object o2, Object o3) {
        return Eval.isEquals(o, o2) || Eval.isEquals(o, o3);
    }

    public static boolean isOrEquals(Object o, Object o2, Object o3, Object o4) {
        return Eval.isEquals(o, o2) || Eval.isEquals(o, o3) || Eval.isEquals(o, o4);
    }

    public static boolean isEquals(char[] a, char[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        if (a.length != a2.length) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            if (a[i] != a2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isEquals(boolean[] a, boolean[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        if (a.length != a2.length) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            if (a[i] != a2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isEquals(byte[] a, byte[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        if (a.length != a2.length) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            if (a[i] != a2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isEquals(short[] a, short[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        if (a.length != a2.length) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            if (a[i] != a2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isEquals(int[] a, int[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        if (a.length != a2.length) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            if (a[i] != a2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isEquals(long[] a, long[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        if (a.length != a2.length) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            if (a[i] != a2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isEquals(float[] a, float[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        if (a.length != a2.length) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            if (a[i] != a2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isEquals(double[] a, double[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        if (a.length != a2.length) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            if (a[i] != a2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isEquals(Object[] a, Object[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        if (a.length != a2.length) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            if (!Eval.isEquals(a[i], a2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isStartsWith(CharSequence cs, CharSequence prefix, int offset) {
        if (Eval.isBlank(cs)) {
            return false;
        }
        return Eval.startsWith(cs, prefix, offset);
    }

    public static boolean isSuffix(CharSequence cs, CharSequence suffix) {
        if (Eval.isBlank(cs)) {
            return false;
        }
        return Eval.suffix(cs, suffix);
    }

    public static boolean isOrSuffix(CharSequence cs, char[] suffixs) {
        if (Eval.isBlank(cs)) {
            return false;
        }
        char suffix = cs.charAt(cs.length() - 1);
        int i = 0;
        while (i < suffixs.length) {
            if (suffix == suffixs[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isOrSuffix(CharSequence cs, CharSequence[] suffixs) {
        if (Eval.isBlank(cs)) {
            return false;
        }
        int i = 0;
        while (i < suffixs.length) {
            if (Eval.suffix(cs, suffixs[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isPrefix(CharSequence cs, CharSequence prefix) {
        if (Eval.isBlank(cs)) {
            return false;
        }
        return Eval.prefix(cs, prefix);
    }

    public static boolean isOrPrefix(CharSequence cs, char[] prefixs) {
        if (Eval.isBlank(cs)) {
            return false;
        }
        char prefix = cs.charAt(0);
        int i = 0;
        while (i < prefixs.length) {
            if (prefix == prefixs[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isOrPrefix(CharSequence cs, CharSequence[] prefixs) {
        if (Eval.isBlank(cs)) {
            return false;
        }
        int i = 0;
        while (i < prefixs.length) {
            if (Eval.prefix(cs, prefixs[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean suffix(CharSequence cs, CharSequence suffix) {
        int end = cs.length() - suffix.length();
        return Eval.startsWith(cs, suffix, end);
    }

    private static boolean prefix(CharSequence cs, CharSequence prefix) {
        return Eval.startsWith(cs, prefix, 0);
    }

    private static boolean startsWith(CharSequence cs, CharSequence prefix, int offset) {
        int plen = prefix.length();
        if (offset < 0 || offset > cs.length() - plen) {
            return false;
        }
        int to = offset;
        int po = 0;
        while (--plen >= 0) {
            if (cs.charAt(to++) == prefix.charAt(po++)) continue;
            return false;
        }
        return true;
    }

    public static boolean isRange(int n, int from, int to) {
        if (from > to) {
            throw new IllegalArgumentException("from > to (" + from + " > " + to + ")");
        }
        return from <= n && n <= to;
    }

    public static boolean isRange(long n, long from, long to) {
        if (from > to) {
            throw new IllegalArgumentException("from > to (" + from + " > " + to + ")");
        }
        return from <= n && n <= to;
    }

    public static boolean isRange(double n, double from, double to) {
        if (from > to) {
            throw new IllegalArgumentException("from > to (" + from + " > " + to + ")");
        }
        return from <= n && n <= to;
    }

    public static boolean isRangeChars(CharSequence cs, char from, char to) {
        if (cs == null) {
            return false;
        }
        int len = cs.length();
        int i = 0;
        while (i < len) {
            if (!Eval.isRange(cs.charAt(i), from, to)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isNegative(int n) {
        return n < 0;
    }

    public static boolean isNegative(long n) {
        return 0L > n;
    }

    public static boolean isNegative(double n) {
        return 0.0 > n;
    }

    public static boolean isPositive(int n) {
        return n >= 0;
    }

    public static boolean isPositive(long n) {
        return 0L <= n;
    }

    public static boolean isPositive(double n) {
        return 0.0 <= n;
    }

    public static boolean isMin(int n, int min) {
        return min <= n;
    }

    public static boolean isMin(long n, long min) {
        return min <= n;
    }

    public static boolean isMin(double n, double min) {
        return min <= n;
    }

    public static boolean isMax(int n, int max) {
        return n <= max;
    }

    public static boolean isMax(long n, long max) {
        return n <= max;
    }

    public static boolean isMax(double n, double max) {
        return n <= max;
    }

    public static boolean isContains(boolean[] a, boolean e) {
        int i = 0;
        while (i < a.length) {
            if (e == a[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isContains(char[] a, char e) {
        int i = 0;
        while (i < a.length) {
            if (e == a[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isContains(byte[] a, byte e) {
        int i = 0;
        while (i < a.length) {
            if (e == a[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isContains(short[] a, short e) {
        int i = 0;
        while (i < a.length) {
            if (e == a[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isContains(int[] a, int e) {
        int i = 0;
        while (i < a.length) {
            if (e == a[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isContains(long[] a, long e) {
        int i = 0;
        while (i < a.length) {
            if (e == a[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isContains(float[] a, float e) {
        int i = 0;
        while (i < a.length) {
            if (e == a[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isContains(double[] a, double e) {
        int i = 0;
        while (i < a.length) {
            if (e == a[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isContains(Object[] a, Object o) {
        int i = 0;
        while (i < a.length) {
            if (Eval.isEquals(o, a[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isContains(Collection c, Object o) {
        if (c == null) {
            return false;
        }
        return c.contains(o);
    }

    public static boolean isContains(String source, char c) {
        if (source == null) {
            return false;
        }
        return source.indexOf(c) >= 0;
    }

    public static boolean isContains(String source, String target) {
        if (source == null) {
            return false;
        }
        return source.indexOf(target) >= 0;
    }

    public static boolean isContains(CharSequence cs, char c) {
        if (cs == null) {
            return false;
        }
        return Seek.indexOf(cs, c) >= 0;
    }

    public static boolean isContains(CharSequence cs, CharSequence target) {
        if (cs == null) {
            return false;
        }
        return Seek.indexOf(cs, target) >= 0;
    }

    public static boolean isContainsKey(Map m, Object key) {
        return m != null && m.containsKey(key);
    }

    public static boolean isContainsKey(Group g, Object key) {
        return g != null && g.containsKey(key);
    }

    public static boolean isContainsKey(Parameters p, String key) {
        return p != null && p.containsName(key);
    }

    public static boolean isAndInstance(Object o, Class class1, Class class2) {
        return class1.isInstance(o) && class2.isInstance(o);
    }

    public static boolean isAndInstance(Object o, Class[] classes) {
        int i = 0;
        while (i < classes.length) {
            Class c = classes[i];
            if (!c.isInstance(o)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isOrInstance(Object o, Class class1, Class class2) {
        return class1.isInstance(o) || class2.isInstance(o);
    }

    public static boolean isOrInstance(Object o, Class[] classes) {
        int i = 0;
        while (i < classes.length) {
            Class c = classes[i];
            if (c.isInstance(o)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isType(Object o, Class c) {
        return o != null && o.getClass().equals(c);
    }

    public static boolean isComponentType(Object a, Class c) {
        if (a == null) {
            return false;
        }
        Class<?> type = a.getClass();
        if (!type.isArray()) {
            throw new IllegalArgumentException("is not Array");
        }
        return type.getComponentType().equals(c);
    }

    public static boolean isArray(Object o) {
        return o != null && o.getClass().isArray();
    }

    public static boolean isArrayClass(Class c) {
        return c != null && c.isArray();
    }

    public static boolean isIndex(CharSequence cs, int index) {
        if (cs == null) {
            return false;
        }
        return Eval.isRange(index, 0, cs.length() - 1);
    }

    public static boolean isIndex(CharSequence cs, int min, int max) {
        if (cs == null) {
            return false;
        }
        if (min > max) {
            throw new IllegalArgumentException("min > max (" + min + " > " + max + ")");
        }
        int len = cs.length() - 1;
        return Eval.isRange(min, 0, len) && Eval.isRange(max, 0, len);
    }

    public static boolean isIndex(List list, int index) {
        if (list == null) {
            return false;
        }
        return Eval.isRange(index, 0, list.size() - 1);
    }

    public static boolean isIndex(List list, int min, int max) {
        if (list == null) {
            return false;
        }
        if (min > max) {
            throw new IllegalArgumentException("min > max (" + min + " > " + max + ")");
        }
        int size = list.size() - 1;
        return Eval.isRange(min, 0, size) && Eval.isRange(max, 0, size);
    }

    public static boolean isArrayIndex(Object a, int index) {
        if (a == null) {
            return false;
        }
        return Eval.isRange(index, 0, Array.getLength(a) - 1);
    }

    public static boolean isArrayIndex(Object a, int min, int max) {
        if (a == null) {
            return false;
        }
        if (min > max) {
            throw new IllegalArgumentException("min > max (" + min + " > " + max + ")");
        }
        int size = Array.getLength(a) - 1;
        return Eval.isRange(min, 0, size) && Eval.isRange(max, 0, size);
    }

    public static boolean isSize(CharSequence a, int length) {
        if (a == null) {
            return false;
        }
        return a.length() == length;
    }

    public static boolean isSize(CharSequence cs, int min, int max) {
        if (cs == null) {
            return false;
        }
        if (min > max) {
            throw new IllegalArgumentException("min > max (" + min + " > " + max + ")");
        }
        int size = cs.length();
        return Eval.isRange(min, 0, size) && Eval.isRange(max, 0, size);
    }

    public static boolean isArraySize(Object a, int length) {
        if (a == null) {
            return false;
        }
        return Array.getLength(a) == length;
    }

    public static boolean isArraySize(Object a, int min, int max) {
        if (a == null) {
            return false;
        }
        if (min > max) {
            throw new IllegalArgumentException("min > max (" + min + " > " + max + ")");
        }
        int len = Array.getLength(a);
        return Eval.isRange(len, min, max);
    }

    public static boolean isAndArraySize(Object[] as) {
        if (Eval.isEmpty(as)) {
            throw new IllegalArgumentException("array as empty");
        }
        int len = Array.getLength(as[0]);
        int i = 1;
        while (i < as.length) {
            if (len != Array.getLength(as[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isCharAt(CharSequence cs, int index, char c) {
        return Eval.isIndex(cs, index) && cs.charAt(index) == c;
    }

    public static boolean isOrCharAt(CharSequence cs, int index, char[] ac) {
        if (Eval.isIndex(cs, index)) {
            char c = cs.charAt(index);
            int i = 0;
            while (i < ac.length) {
                if (c == ac[i]) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }
}

