/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import shohaku.core.util.codec.PropertiesEscapesCoder;

public abstract class AbstractXProperties {
    protected static final Charset DEFAULT_CHARSET = Charset.forName("8859_1");
    protected static final String keyValueSeparators = "=: \t\r\n\f";
    protected static final String strictKeyValueSeparators = "=:";
    protected static final String commentChars = "#!";
    protected static final String whiteSpaceChars = " \t\r\n\f";
    protected final Map lookup = this.createLookupMap();
    protected final Set unmodifiableKeys = Collections.unmodifiableSet(this.lookup.keySet());

    protected synchronized void loadImpl(InputStream inStream, Charset charset, boolean isUnicodeEscapes) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(inStream, charset));
        String line;
        while ((line = in.readLine()) != null) {
            String value;
            char firstChar;
            if (line.length() <= 0) continue;
            int len = line.length();
            int keyStart = 0;
            while (keyStart < len) {
                if (!this.isWhiteSpaceChars(line.charAt(keyStart))) break;
                ++keyStart;
            }
            if (keyStart == len || !this.isNotCommentChars(firstChar = line.charAt(keyStart))) continue;
            while (this.continueLine(line)) {
                String nextLine = in.readLine();
                if (nextLine == null) {
                    nextLine = "";
                }
                String loppedLine = line.substring(0, len - 1);
                int startIndex = 0;
                while (startIndex < nextLine.length()) {
                    if (!this.isWhiteSpaceChars(nextLine.charAt(startIndex))) break;
                    ++startIndex;
                }
                nextLine = nextLine.substring(startIndex, nextLine.length());
                line = new String(String.valueOf(loppedLine) + nextLine);
                len = line.length();
            }
            int separatorIndex = keyStart;
            while (separatorIndex < len) {
                char currentChar = line.charAt(separatorIndex);
                if (currentChar == '\\') {
                    ++separatorIndex;
                } else if (this.isKeyValueSeparators(currentChar)) break;
                ++separatorIndex;
            }
            int valueIndex = separatorIndex;
            while (valueIndex < len) {
                if (!this.isWhiteSpaceChars(line.charAt(valueIndex))) break;
                ++valueIndex;
            }
            if (valueIndex < len && this.isKeyValueSeparators(line.charAt(valueIndex))) {
                ++valueIndex;
            }
            while (valueIndex < len) {
                if (!this.isWhiteSpaceChars(line.charAt(valueIndex))) break;
                ++valueIndex;
            }
            String key = line.substring(keyStart, separatorIndex);
            String string = value = separatorIndex < len ? line.substring(valueIndex, len) : "";
            if (isUnicodeEscapes) {
                key = PropertiesEscapesCoder.decode(key);
                value = PropertiesEscapesCoder.decode(value);
            }
            this.putProperty(key, value);
        }
        return;
    }

    protected boolean continueLine(String line) {
        int slashCount = 0;
        int index = line.length() - 1;
        while (index >= 0 && line.charAt(index--) == '\\') {
            ++slashCount;
        }
        return slashCount % 2 == 1;
    }

    protected boolean isNotCommentChars(char c) {
        return commentChars.indexOf(c) == -1;
    }

    protected boolean isKeyValueSeparators(char c) {
        return keyValueSeparators.indexOf(c) != -1;
    }

    protected boolean isWhiteSpaceChars(char c) {
        return whiteSpaceChars.indexOf(c) != -1;
    }

    protected Map createLookupMap() {
        return new HashMap();
    }

    public Iterator keyIterator() {
        return this.unmodifiableKeys.iterator();
    }

    public Map toMap() {
        return new HashMap(this.lookup);
    }

    public Object getProperty(Object key) {
        return this.lookup.get(key);
    }

    public Object getProperty(Object key, Object defaultValue) {
        Object o = this.getProperty(key);
        return o != null ? o : defaultValue;
    }

    public boolean containsKey(Object key) {
        return this.lookup.containsKey(key);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        Iterator i = this.lookup.entrySet().iterator();
        boolean hasNext = i.hasNext();
        while (hasNext) {
            Map.Entry e = i.next();
            Object key = e.getKey();
            Object value = e.getValue();
            buf.append(key);
            buf.append('=');
            buf.append(value);
            hasNext = i.hasNext();
            if (!hasNext) continue;
            buf.append(", ");
        }
        buf.append("}");
        return buf.toString();
    }

    protected abstract void putProperty(String var1, String var2) throws IOException;

    public abstract void load(InputStream var1) throws IOException;

    public abstract void load(InputStream var1, String var2) throws IOException;

    public abstract void load(InputStream var1, Charset var2) throws IOException;
}

