/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Iterator;
import shohaku.core.helpers.Cutter;
import shohaku.core.lang.NoSuchResourceException;
import shohaku.core.lang.ResourceLoader;
import shohaku.core.util.AbstractXProperties;
import shohaku.core.util.cel.CELBinder;
import shohaku.core.util.cel.CELContext;

public class CELProperties
extends AbstractXProperties {
    protected final CELBinder binder;
    protected final CELContext context = new CELContext(){
        private HashMap m = new HashMap();

        public Iterator nameIterator() {
            return this.m.keySet().iterator();
        }

        public Object getValue(String name) {
            return this.m.get(name);
        }

        public Object setValue(String name, Object value) {
            return this.m.put(name, value);
        }

        public boolean containsName(String name) {
            return this.m.containsKey(name);
        }
    };

    public CELProperties() {
        this(CELBinder.getObjectCreationBinder());
    }

    public CELProperties(CELBinder binder) {
        this.binder = binder;
    }

    public synchronized void load(InputStream inStream) throws IOException {
        this.loadImpl(inStream, DEFAULT_CHARSET, true);
    }

    public synchronized void load(InputStream inStream, String charsetName) throws IOException {
        this.loadImpl(inStream, Charset.forName(charsetName), false);
    }

    public synchronized void load(InputStream inStream, Charset charset) throws IOException {
        this.loadImpl(inStream, charset, false);
    }

    public Object getProperty(String key) {
        return this.lookup.get(key);
    }

    public Object getProperty(String key, Object defaultValue) {
        Object o = this.getProperty(key);
        return o == null ? defaultValue : o;
    }

    protected void putProperty(String key, String value) throws IOException {
        if (key.charAt(0) == '$') {
            this.context.setValue(key.substring(1), this.binder.getValue(value, this.context));
        } else if (key.charAt(0) == '@') {
            if (key.equals("@import")) {
                Class c = null;
                try {
                    c = ResourceLoader.getClass(value);
                }
                catch (NoSuchResourceException e) {
                    throw new IOException(e.getMessage());
                }
                String className = Cutter.cutLastIndexOf(c.getName(), '.', 0);
                this.context.setValue(className, c);
            }
        } else {
            this.lookup.put(key, this.binder.getValue(value, this.context));
        }
    }
}

