/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.util.cel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import shohaku.core.helpers.Eval;
import shohaku.core.helpers.Seek;
import shohaku.core.util.cel.CELBinder;
import shohaku.core.util.cel.CELContext;
import shohaku.core.util.cel.CELFormatException;
import shohaku.core.util.cel.CELReturnValue;

public class CELUtils {
    public static CELReturnValue getArguments(CELBinder binder, String exp, int beginIndex, CELContext context) {
        CELReturnValue rValue = CELUtils.getArrayListReturnValue(binder, exp, beginIndex, context, '(', ')');
        List list = (List)rValue.value;
        return new CELReturnValue(list.toArray(), rValue.nextIndex);
    }

    public static CELReturnValue getUnmodifiableList(CELBinder binder, String exp, int beginIndex, CELContext context) {
        CELReturnValue rValue = CELUtils.getArrayListReturnValue(binder, exp, beginIndex, context, '[', ']');
        List list = Collections.unmodifiableList((List)rValue.value);
        return new CELReturnValue(list, rValue.nextIndex);
    }

    public static CELReturnValue getUnmodifiableSet(CELBinder binder, String exp, int beginIndex, CELContext context) {
        CELReturnValue rValue = CELUtils.getLinkedHashSetReturnValue(binder, exp, beginIndex, context, '<', '>');
        Set set = Collections.unmodifiableSet((Set)rValue.value);
        return new CELReturnValue(set, rValue.nextIndex);
    }

    public static CELReturnValue getArrayListReturnValue(CELBinder binder, String exp, int beginIndex, CELContext context, char beginLiteral, char endLiteral) {
        int off;
        if (!Eval.isCharAt(exp, beginIndex, beginLiteral)) {
            throw new CELFormatException("format err :" + exp);
        }
        ArrayList<Object> list = new ArrayList<Object>();
        if (!Eval.isCharAt(exp, off = ++beginIndex, endLiteral)) {
            while (off < exp.length()) {
                off = Seek.skipSp(exp, off);
                CELReturnValue rValue = binder.getReturnValue(exp, off, context);
                list.add(rValue.value);
                off = Seek.skipSp(exp, rValue.nextIndex);
                if (off >= exp.length() || Eval.isCharAt(exp, off, endLiteral)) break;
                if (!Eval.isCharAt(exp, off, ',')) {
                    throw new CELFormatException("format err :" + exp);
                }
                ++off;
                off = Seek.skipSp(exp, off);
            }
            if (!Eval.isCharAt(exp, off = Seek.skipSp(exp, off), endLiteral)) {
                throw new CELFormatException("format err :" + exp);
            }
            if (list.isEmpty()) {
                throw new CELFormatException("format err :" + exp);
            }
        }
        return new CELReturnValue(list, ++off);
    }

    public static CELReturnValue getLinkedHashSetReturnValue(CELBinder binder, String exp, int beginIndex, CELContext context, char beginLiteral, char endLiteral) {
        int off;
        if (!Eval.isCharAt(exp, beginIndex, beginLiteral)) {
            throw new CELFormatException("format err :" + exp);
        }
        LinkedHashSet<Object> set = new LinkedHashSet<Object>();
        if (!Eval.isCharAt(exp, off = ++beginIndex, endLiteral)) {
            while (off < exp.length()) {
                off = Seek.skipSp(exp, off);
                CELReturnValue rValue = binder.getReturnValue(exp, off, context);
                set.add(rValue.value);
                off = Seek.skipSp(exp, rValue.nextIndex);
                if (off >= exp.length() || Eval.isCharAt(exp, off, endLiteral)) break;
                if (!Eval.isCharAt(exp, off, ',')) {
                    throw new CELFormatException("format err :" + exp);
                }
                ++off;
                off = Seek.skipSp(exp, off);
            }
            if (!Eval.isCharAt(exp, off = Seek.skipSp(exp, off), endLiteral)) {
                throw new CELFormatException("format err :" + exp);
            }
            if (set.isEmpty()) {
                throw new CELFormatException("format err :" + exp);
            }
        }
        return new CELReturnValue(set, ++off);
    }

    public static CELReturnValue getUnmodifiableMap(CELBinder binder, String exp, int beginIndex, CELContext context) {
        CELReturnValue rValue = CELUtils.getLinkedHashMapReturnValue(binder, exp, beginIndex, context, '{', '}');
        Map map = Collections.unmodifiableMap((Map)rValue.value);
        return new CELReturnValue(map, rValue.nextIndex);
    }

    public static CELReturnValue getLinkedHashMapReturnValue(CELBinder binder, String exp, int beginIndex, CELContext context, char beginLiteral, char endLiteral) {
        int off;
        if (!Eval.isCharAt(exp, beginIndex, beginLiteral)) {
            throw new CELFormatException("format err :" + exp);
        }
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        if (!Eval.isCharAt(exp, off = ++beginIndex, endLiteral)) {
            while (off < exp.length()) {
                off = Seek.skipSp(exp, off);
                CELReturnValue rKey = binder.getReturnValue(exp, off, context);
                off = Seek.skipSp(exp, rKey.nextIndex);
                if (off >= exp.length()) {
                    throw new CELFormatException("format err :" + exp);
                }
                if (!Eval.isCharAt(exp, off, '=')) {
                    throw new CELFormatException("format err :" + exp);
                }
                ++off;
                off = Seek.skipSp(exp, off);
                CELReturnValue rValue = binder.getReturnValue(exp, off, context);
                off = Seek.skipSp(exp, rValue.nextIndex);
                map.put(rKey.value, rValue.value);
                if (off >= exp.length() || Eval.isCharAt(exp, off, endLiteral)) break;
                if (!Eval.isCharAt(exp, off, ',')) {
                    throw new CELFormatException("format err :" + exp);
                }
                ++off;
                off = Seek.skipSp(exp, off);
            }
            if (!Eval.isCharAt(exp, off = Seek.skipSp(exp, off), endLiteral)) {
                throw new CELFormatException("format err :" + exp);
            }
            if (map.isEmpty()) {
                throw new CELFormatException("format err :" + exp);
            }
        }
        return new CELReturnValue(map, ++off);
    }

    public static int findNextIndex(String expression, int beginIndex, char endLiteral) {
        int off = ++beginIndex;
        while (off < expression.length()) {
            if (-1 == (off = expression.indexOf(endLiteral, off))) {
                return -1;
            }
            if (off == 0 || off > 0 && '\\' != expression.charAt(off - 1)) break;
            ++off;
        }
        return off + 1;
    }
}

