/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.util.cel;

import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import shohaku.core.beans.BeanUtilities;
import shohaku.core.beans.InvocationBeansException;
import shohaku.core.helpers.Cutter;
import shohaku.core.helpers.Eval;
import shohaku.core.helpers.Seek;
import shohaku.core.util.cel.CELBinder;
import shohaku.core.util.cel.CELContext;
import shohaku.core.util.cel.CELExpression;
import shohaku.core.util.cel.CELFormatException;
import shohaku.core.util.cel.CELLiteral;
import shohaku.core.util.cel.CELReturnValue;
import shohaku.core.util.cel.CELUtils;

public class IntrospectExpression
implements CELExpression {
    private static final CELLiteral literal = new CELLiteral('%', '%');

    public CELLiteral getLiteral() {
        return literal;
    }

    public CELReturnValue execute(CELBinder binder, String expression, int beginIndex, CELContext context) {
        int off = ++beginIndex;
        String exp = expression;
        Object o = null;
        off = Seek.skipSp(exp, off);
        CELReturnValue stRValue = binder.getReturnValue(exp, off, context);
        o = stRValue.value;
        off = stRValue.nextIndex;
        off = Seek.skipSp(exp, off);
        try {
            while (off < exp.length()) {
                int _skipOff = Seek.skipSp(exp, off);
                if (!Eval.isCharAt(exp, _skipOff, IntrospectExpression.literal.end)) {
                    int end;
                    if (Eval.isCharAt(exp, off, '[')) {
                        String key = Cutter.cutIndexOf(exp, ++off, ']');
                        if (o instanceof Map) {
                            o = ((Map)o).get(key);
                        } else {
                            int index = Integer.parseInt(key);
                            if (o instanceof List) {
                                o = ((List)o).get(index);
                            } else if (Eval.isArray(o)) {
                                o = Array.get(o, index);
                            } else {
                                throw new CELFormatException("format err :" + exp);
                            }
                        }
                        off += key.length() + 1;
                        continue;
                    }
                    if (Eval.isCharAt(exp, off, '.')) {
                        ++off;
                    }
                    if (-1 < (end = Seek.orIndexOf(exp, "[(.#%".toCharArray(), off))) {
                        if (Eval.isCharAt(exp, end, '(')) {
                            String methodName = exp.substring(off, end);
                            CELReturnValue args = CELUtils.getArguments(binder, exp, end, context);
                            Class<?> c = o instanceof Class ? (Class<?>)o : o.getClass();
                            o = BeanUtilities.invokeMethod(c, o, methodName, (Object[])args.value);
                            off = args.nextIndex;
                            continue;
                        }
                        if (Eval.isCharAt(exp, end, '#')) {
                            String fieldName = exp.substring(off, end);
                            o = BeanUtilities.getFieldValue(o, fieldName);
                            off = end;
                            continue;
                        }
                        String propertyName = exp.substring(off, end);
                        o = BeanUtilities.getProperty(o, propertyName);
                        off = end;
                        continue;
                    }
                    throw new CELFormatException("format err :" + exp);
                }
                break;
            }
        }
        catch (InvocationBeansException e) {
            throw new CELFormatException("format err :" + exp, e);
        }
        catch (IndexOutOfBoundsException e) {
            throw new CELFormatException("format err :" + exp, e);
        }
        catch (NumberFormatException e) {
            throw new CELFormatException("format err :" + exp, e);
        }
        if (!Eval.isCharAt(exp, off = Seek.skipSp(exp, off), IntrospectExpression.literal.end)) {
            throw new CELFormatException("format err :" + exp);
        }
        return new CELReturnValue(o, ++off);
    }
}

