/*
 * Decompiled with CFR 0.152.
 */
package shohaku.ginkgo;

import java.util.Iterator;
import shohaku.core.helpers.Eval;
import shohaku.ginkgo.Node;
import shohaku.ginkgo.NodeAttributesRule;
import shohaku.ginkgo.NodeContext;

public abstract class AbstractNode
implements Node {
    private NodeContext nodeContext;

    public boolean isType(int type) {
        return false;
    }

    public int getScope() {
        int scope = this.getNodeScope();
        if (this.nodeContext.getParent() != null) {
            int parentScope = this.nodeContext.getParent().getScope();
            scope = parentScope > scope ? parentScope : scope;
        }
        return scope;
    }

    protected int getNodeScope() {
        return 102;
    }

    public String getId() {
        return this.getAttribute("id");
    }

    public Object getNodeValue() {
        return null;
    }

    public NodeContext getContext() {
        return this.nodeContext;
    }

    public String getAttribute(String name) {
        String value = null;
        NodeAttributesRule rule = this.getContext().getNodeAttributesRule(name);
        if (rule != null) {
            if (!Eval.isBlank((CharSequence)rule.getAlias())) {
                name = rule.getAlias();
            }
            if (Eval.isBlank((CharSequence)(value = this.getContext().getTagAttribute(name)))) {
                value = rule.getDefaultValue();
            }
        } else {
            value = this.getContext().getTagAttribute(name);
        }
        return value;
    }

    public String getAttribute(String name, String defaultValue) {
        String value = this.getAttribute(name);
        return value != null ? value : defaultValue;
    }

    public String getText() {
        StringBuffer sb = new StringBuffer();
        Iterator i = this.nodeContext.textIterator();
        while (i.hasNext()) {
            sb.append(((Node)i.next()).getText());
        }
        return sb.toString();
    }

    public void initialize(NodeContext nodeContext) {
        this.nodeContext = nodeContext;
    }

    public void begin() {
    }

    public void child(Node node) {
    }

    public void end() {
    }

    public void finish() {
    }
}

