/*
 * Decompiled with CFR 0.152.
 */
package shohaku.ginkgo.nodes;

import shohaku.core.helpers.Eval;
import shohaku.ginkgo.GinkgoException;
import shohaku.ginkgo.Node;
import shohaku.ginkgo.nodes.NodeCompositeUtilities;

public class NodeCompositeFeature {
    public Class getTextToClass(Node node) {
        String className = node.getText();
        if (Eval.isBlank((CharSequence)className)) {
            return null;
        }
        return NodeCompositeUtilities.loadClass(node.getContext(), className);
    }

    public Class getAttributeToClass(Node node, String name) {
        String className = node.getAttribute(name);
        if (Eval.isBlank((CharSequence)className)) {
            return null;
        }
        return NodeCompositeUtilities.loadClass(node.getContext(), className);
    }

    public Class getAttributeToClass(Node node, String name, Class defaultValue) {
        Class o = this.getAttributeToClass(node, name);
        if (o == null) {
            return defaultValue;
        }
        return o;
    }

    public Object getTextRef(Node node) {
        String refId = node.getText();
        return this.getReferenceValue(node, refId);
    }

    public Object getAttributeRef(Node node, String name) {
        String refId = node.getAttribute(name);
        return this.getReferenceValue(node, refId);
    }

    public Object getAttributeRef(Node node, String name, Object defaultValue) {
        Object o = this.getAttributeRef(node, name);
        if (o == null) {
            return defaultValue;
        }
        return o;
    }

    public Object getReferenceValue(Node node, String id) {
        return NodeCompositeUtilities.getReferenceValue(node.getContext(), id);
    }

    public boolean isReferenceContainsName(Node node, String id) {
        return NodeCompositeUtilities.isReferenceContainsName(node.getContext(), id);
    }

    public Object getCELValue(Node node, String value) {
        return NodeCompositeUtilities.toCELValue(node.getContext(), value);
    }

    public String getTextValue(Node node) {
        return NodeCompositeUtilities.getTextValueToString(node.getContext());
    }

    public boolean getBoolean(String value) {
        if (!NodeCompositeUtilities.isBoolean(value)) {
            throw new GinkgoException("illegal format of Boolean. " + value);
        }
        return NodeCompositeUtilities.getBoolean(value);
    }

    public String toNumberString(CharSequence value) {
        return NodeCompositeUtilities.toJavaNumberString(value);
    }
}

