/*
 * shohaku
 * Copyright (C) 2005  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.kosho;

import java.io.InputStream;

import shohaku.ginkgo.GinkgoException;
import shohaku.ginkgo.NodeCompositeRule;

/**
 * コンフィギュレーションリソースを入力ストリームから読み取る機能を提供します。
 */
public interface KoshoResourcesLoader {

    /**
     * デフォルトの構成ルールを用いて、入力ストリームから構成リソースを読み込みます。
     * 
     * @param inStream
     *            構成リソースの入力ストリーム
     * @throws GinkgoException
     *             構成情報例外
     */
    public void load(InputStream inStream) throws GinkgoException;

    /**
     * 指定された構成ルールを用いて、入力ストリームから構成リソースを読み込みます。
     * 
     * @param inStream
     *            構成リソースの入力ストリーム
     * @param rule
     *            構成ルール
     * @throws GinkgoException
     *             構成情報例外
     */
    public void load(InputStream inStream, NodeCompositeRule rule) throws GinkgoException;

}
