package shohaku.sample.kosho;

/*
 * shohaku
 * Copyright (C) 2005  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/**
 * 湖を表現する。
 */
public class Lake {

    /* 湖の有る県名。 */
    private String prefectureName;

    /* 湖の名前。 */
    private String name;

    /**
     * 指定のプロパティで生成して返却します。
     * 
     * @param prefectureName
     *            湖の有る県名
     * @param name
     *            湖の名前
     * @return 生成されたインスタンス
     */
    public static Lake getInstance(String prefectureName, String name) {
        return new Lake(prefectureName, name);
    }

    /**
     * プロパティをnullで初期化します。
     */
    public Lake() {
        // no op
    }

    /**
     * 指定のプロパティで初期化します。
     * 
     * @param prefectureName
     *            湖の有る県名
     * @param name
     *            湖の名前
     */
    public Lake(String prefectureName, String name) {
        this.prefectureName = prefectureName;
        this.name = name;
    }

    /**
     * 湖の名前を返却します。
     * 
     * @return 湖の名前
     */
    public String getName() {
        return name;
    }

    /**
     * 湖の名前を格納します。
     * 
     * @param name
     *            湖の名前
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * 湖の有る県名を返却します。
     * 
     * @return 湖の有る県名
     */
    public String getPrefectureName() {
        return prefectureName;
    }

    /**
     * 湖の有る県名を格納します。
     * 
     * @param prefectureName
     *            湖の有る県名
     */
    public void setPrefectureName(String prefectureName) {
        this.prefectureName = prefectureName;
    }

    /**
     * 県名と名前を出力します。
     * 
     * @return 県名と名前
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return "Lake(prefectureName=" + prefectureName + ", name=" + name + ")";
    }

}
