/*
 * shohaku Copyright (C) 2005 tomoya nagatani
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */
package shohaku.kosho;

import java.util.Date;
import java.util.Map;

/**
 */
public class TestBean {

    private String arg0;

    private int arg1;

    private byte arg2;

    private Date arg3;

    private int sunday;

    private long monday;

    private byte tuesday;

    private String wednesday;

    private String thursday;

    private String friday;

    private String saturday;

    private Map week;

    /**
     *  
     */
    public TestBean() {
        super();
    }

    public TestBean(String arg0, int arg1, byte arg2, Date arg3) {
        this.arg0 = arg0;
        this.arg1 = arg1;
        this.arg2 = arg2;
        this.arg3 = arg3;
    }

    public static TestBean getInstance() {
        return new TestBean();
    }

    public static TestBean getInstance(String arg0, int arg1, byte arg2, Date arg3) {
        return new TestBean(arg0, arg1, arg2, arg3);
    }

    /**
     * @return
     */
    public String getArg0() {
        return arg0;
    }

    /**
     * @return
     */
    public int getArg1() {
        return arg1;
    }

    /**
     * @return
     */
    public byte getArg2() {
        return arg2;
    }

    /**
     * @return
     */
    public Date getArg3() {
        return arg3;
    }

    /**
     * @return
     */
    public String getFriday() {
        return friday;
    }

    /**
     * @return
     */
    public long getMonday() {
        return monday;
    }

    /**
     * @return
     */
    public String getSaturday() {
        return saturday;
    }

    /**
     * @return
     */
    public int getSunday() {
        return sunday;
    }

    /**
     * @return
     */
    public String getThursday() {
        return thursday;
    }

    /**
     * @return
     */
    public byte getTuesday() {
        return tuesday;
    }

    /**
     * @return
     */
    public String getWednesday() {
        return wednesday;
    }

    /**
     * @param string
     */
    public void setArg0(String string) {
        arg0 = string;
    }

    /**
     * @param i
     */
    public void setArg1(int i) {
        arg1 = i;
    }

    /**
     * @param b
     */
    public void setArg2(byte b) {
        arg2 = b;
    }

    /**
     * @param date
     */
    public void setArg3(Date date) {
        arg3 = date;
    }

    /**
     * @param string
     */
    public void setFriday(String string) {
        friday = string;
    }

    /**
     * @param l
     */
    public void setMonday(long l) {
        monday = l;
    }

    /**
     * @param string
     */
    public void setSaturday(String string) {
        saturday = string;
    }

    /**
     * @param i
     */
    public void setSunday(int i) {
        sunday = i;
    }

    /**
     * @param string
     */
    public void setThursday(String string) {
        thursday = string;
    }

    /**
     * @param b
     */
    public void setTuesday(byte b) {
        tuesday = b;
    }

    /**
     * @param string
     */
    public void setWednesday(String string) {
        wednesday = string;
    }

    /**
     * week を返却します。
     * 
     * @return week。
     */
    public synchronized Map getWeek() {
        return week;
    }

    /**
     * week を格納します。
     * 
     * @param week
     *            week。
     */
    public synchronized void setWeek(Map week) {
        this.week = week;
    }
}
