/*
 * shohaku
 * Copyright (C) 2005  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.kosho;

import java.io.InputStream;

import shohaku.core.beans.BindMethod;
import shohaku.core.collections.params.Parameters;
import shohaku.core.lang.ResourceLoader;
import shohaku.core.util.debug.Debug;

/**
 * TestBindMethodFactory
 */
public class TestBindMethodFactory {

    public static void main(String[] args) {

        try {

            InputStream inStream = ResourceLoader.getResourceAsStream("shohaku/kosho/test-bind-method-factory.xml");

            BindMethodFactory factory = new BindMethodFactory();
            factory.load(inStream);

            Debug.out.printlf(1);
            Debug.out.printLineln(60);
            Debug.out.println(TestBindMethodFactory.class.getName());
            Debug.out.printLineln(60);

            // /////////
            BindMethod o = factory.getBindMethod("test:yyyyMMdd");
            Debug.out.printBean(o);

            Debug.out.printlf(1);
            Debug.out.println(o.invoke(new Parameters(new Object[] { "value", "2003/12/30" })));
            Debug.out.printlf(1);

            Debug.out.printlf(1);
            BindMethod o2 = factory.getBindMethod("test:yyyyMMddHHmmSS");
            Debug.out.printBean(o2);

            Debug.out.printlf(1);
            Debug.out.println(o2.invoke(new Parameters(new Object[] { "value", "2005/12/30 20:11:59.234" })));
            Debug.out.printlf(1);

            Debug.out.printlf(1);
            BindMethod o3 = factory.getBindMethod("test:yyyyMMddHHmmSS2");
            Debug.out.printBean(o3);

            Debug.out.printlf(1);
            Debug.out.println(o3.invoke(new Parameters(new Object[] { "value", "2008/12/30 20:11:59.500" })));
            Debug.out.printlf(1);
            // //////////

            Debug.out.printlf(1);
            Debug.out.printLineln(60);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
