/*
 * shohaku Copyright (C) 2005 tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */
package shohaku.kosho;

import java.util.Date;
import java.util.Iterator;

import shohaku.core.util.debug.Debug;

/**
 * TestXMLClassBindConstant
 */
public class TestClassBindConfiguration {
    private static DefaultKoshoResources constants;
    static {
        try {

            constants = new DefaultKoshoResources(Kosho.getClassBindConfiguration(TestClassBindConfiguration.class));

            Debug.out.printlf(1);
            Debug.out.printLineln(60);
            Debug.out.println(TestClassBindConfiguration.class.getName());
            Debug.out.printLineln(60);
            for (Iterator i = constants.keyIterator(); i.hasNext();) {
                String key = (String) i.next();
                Object value = constants.getObject(key);
                Debug.out.print(key);
                Debug.out.print(" : ");
                Debug.out.println(value);
                Debug.out.println(value.getClass());
            }

            constants = new DefaultKoshoResources(Kosho.getClassBindConfiguration(TestClassBindConfiguration.class));

        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static final transient Date TIMESTAMP = constants.getDate("TIMESTAMP");

    public static final String SUNDAY = constants.getString("SUNDAY");

    public static final String MONDAY = constants.getString("MONDAY");

    public static final String TUESDAY = constants.getString("TUESDAY");

    public static final String WEDNESDAY = constants.getString("WEDNESDAY");

    public static final String THURSDAY = constants.getString("THURSDAY");

    public static final String FRIDAY = constants.getString("FRIDAY");

    public static final String SATURDAY = constants.getString("SATURDAY");

    public static final Date WEEK_TIMESTAMP = constants.getDate("WEEK_TIMESTAMP");

    public static final String WEEK_SUNDAY = constants.getString("WEEK_SUNDAY");

    public static final String WEEK_MONDAY = constants.getString("WEEK_MONDAY");

    public static final String WEEK_TUESDAY = constants.getString("WEEK_TUESDAY");

    public static final String WEEK_WEDNESDAY = constants.getString("WEEK_WEDNESDAY");

    public static final String WEEK_THURSDAY = constants.getString("WEEK_THURSDAY");

    public static final String WEEK_FRIDAY = constants.getString("WEEK_FRIDAY");

    public static final String WEEK_SATURDAY = constants.getString("WEEK_SATURDAY");

    public transient volatile String sunday = constants.getString("sunday");

    public final String monday = constants.getString("monday");

    public String tuesday = constants.getString("tuesday");

    public String wednesday = constants.getString("wednesday");

    public String thursday = constants.getString("thursday");

    public String friday = constants.getString("friday");

    public String saturday = constants.getString("saturday");

    public String week_sunday = constants.getString("week.text.sunday");

    public String week_monday = constants.getString("week.text.monday");

    public String week_tuesday = constants.getString("week.text.tuesday");

    public String week_wednesday = constants.getString("week.text.wednesday");

    public String week_thursday = constants.getString("week.text.thursday");

    public String week_friday = constants.getString("week.text.friday");

    public String week_saturday = constants.getString("week.text.saturday");

    public String[] week_array = (String[]) constants.getArrays("week.array");

    public int[] week_array_code = (int[]) constants.getArrays("week.array.code");

    public static void main(String[] args) {

        try {
            TestClassBindConfiguration o = new TestClassBindConfiguration();
            Debug.out.printlf(1);
            Debug.out.printLineln(60);
            Debug.out.printFields(o);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
