/*
 * shohaku Copyright (C) 2005 tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */
package shohaku.kosho;

import java.io.InputStream;
import java.util.Iterator;

import shohaku.core.lang.ResourceLoader;
import shohaku.core.util.debug.Debug;

/**
 *  
 */
public class TestClassMappingConfiguration {
    public static void main(String[] args) {

        try {
            InputStream inStream = ResourceLoader
                    .getResourceAsStream("shohaku/kosho/test-class-mapping-configuration.xml");

            ClassMappingConfiguration xmlConstant = new ClassMappingConfiguration();
            xmlConstant.load(inStream);

            for (Iterator i = xmlConstant.classNameIterator(); i.hasNext();) {
                Class c = ResourceLoader.getClass((String) i.next());
                DefaultKoshoResources resources = new DefaultKoshoResources(xmlConstant.getResources(c));

                Debug.out.printlf(1);
                Debug.out.printLineln(60);
                Debug.out.println(c.getName());
                Debug.out.printLineln(60);
                for (Iterator j = resources.keyIterator(); j.hasNext();) {
                    String key = (String) j.next();
                    Object value = resources.getObject(key);
                    Debug.out.print(key);
                    Debug.out.print(" : ");
                    Debug.out.println(value);
                    Debug.out.println(value.getClass());
                }
            }

        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
