/*
 * shohaku Copyright (C) 2005 tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */
package shohaku.kosho;

import shohaku.core.util.debug.Debug;

/**
 * TestComponentFactory
 */
public class TestComponentFactory {

    public static void main(String[] args) {

        try {

            ComponentFactory factory = ComponentFactory.getFactory("shohaku/kosho/test-component-factory.xml");
            {
                Debug.out.printlf(1);
                Debug.out.printLineln(60);
                Debug.out.println(TestComponentFactory.class.getName());
                Debug.out.printLineln(60);

                // /////////
                TestBean o = (TestBean) factory.getComponent("test:TestBean");
                o.setArg0("シングルトン変更");
                Debug.out.print("test:TestBean:");
                Debug.out.printBean(o);

                Debug.out.printlf(1);
                Debug.out.print("test:TestBean:");
                Debug.out.printBean(factory.getComponent("test:TestBean"));
                // //////////
                Debug.out.printlf(2);

                // //////////
                TestBean o2 = (TestBean) factory.getComponent("test:TestBean2");
                o2.setArg0("プロトタイプ変更");
                Debug.out.print("test:TestBean2:");
                Debug.out.printBean(o2);

                Debug.out.printlf(1);
                Debug.out.print("test:TestBean2:");
                Debug.out.printBean(factory.getComponent("test:TestBean2"));
                // //////////

                Debug.out.printlf(1);
                Debug.out.printLineln(60);
            }
            // ////////////////////////////////////////////////////////////////////////////////
            {

                Debug.out.printlf(1);
                Debug.out.println("CEL式を用いて定義する");
                Debug.out.printLineln(60);
                Debug.out.println(TestComponentFactory.class.getName());
                Debug.out.printLineln(60);

                // /////////
                TestBean o = (TestBean) factory.getComponent("cel-test:TestBean");
                o.setArg0("シングルトン変更");
                Debug.out.print("cel-test:TestBean:");
                Debug.out.printBean(o);

                Debug.out.printlf(1);
                Debug.out.print("cel-test:TestBean:");
                Debug.out.printBean(factory.getComponent("cel-test:TestBean"));
                // //////////
                Debug.out.printlf(2);

                // //////////
                TestBean o2 = (TestBean) factory.getComponent("cel-test:TestBean2");
                o2.setArg0("プロトタイプ変更");
                Debug.out.print("cel-test:TestBean2:");
                Debug.out.printBean(o2);

                Debug.out.printlf(1);
                Debug.out.print("cel-test:TestBean2:");
                Debug.out.printBean(factory.getComponent("cel-test:TestBean2"));
                // //////////

                Debug.out.printlf(1);
                Debug.out.printLineln(60);
            }

        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
