/*
 * shohaku Copyright (C) 2005 tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */
package shohaku.kosho;

import java.util.Iterator;
import java.util.Locale;

import shohaku.core.util.debug.Debug;

/**
 */
public class TestXMLLocaleResourceBundle {

    public static void main(String[] args) {

        try {
            KoshoResources bundle = null;
            Debug.out.println();
            Debug.out.println(new Locale("", "", ""));
            bundle = Kosho.getXMLLocaleResourceBundle("shohaku/kosho/test-xml-resource");
            for (Iterator i = bundle.keyIterator(); i.hasNext();) {
                String key = (String) i.next();
                Object value = bundle.getObject(key);
                Debug.out.print(key);
                Debug.out.print(" : ");
                Debug.out.println(value);
                Debug.out.println(value.getClass());
            }

            Debug.out.println();
            Debug.out.println(new Locale("en", "", ""));
            bundle = Kosho.getXMLLocaleResourceBundle("shohaku/kosho/test-xml-resource", new Locale("en"));
            for (Iterator i = bundle.keyIterator(); i.hasNext();) {
                String key = (String) i.next();
                Object value = bundle.getObject(key);
                Debug.out.print(key);
                Debug.out.print(" : ");
                Debug.out.println(value);
                Debug.out.println(value.getClass());
            }

            Debug.out.println();
            Debug.out.println(new Locale("en", "us", ""));
            bundle = Kosho.getXMLLocaleResourceBundle("shohaku/kosho/test-xml-resource", new Locale("en", "us"));
            for (Iterator i = bundle.keyIterator(); i.hasNext();) {
                String key = (String) i.next();
                Object value = bundle.getObject(key);
                Debug.out.print(key);
                Debug.out.print(" : ");
                Debug.out.println(value);
                Debug.out.println(value.getClass());
            }

            Debug.out.println();
            Debug.out.println(new Locale("en", "us", "win"));
            bundle = Kosho.getXMLLocaleResourceBundle("shohaku/kosho/test-xml-resource", new Locale("en", "us", "win"));
            for (Iterator i = bundle.keyIterator(); i.hasNext();) {
                String key = (String) i.next();
                Object value = bundle.getObject(key);
                Debug.out.print(key);
                Debug.out.print(" : ");
                Debug.out.println(value);
                Debug.out.println(value.getClass());
            }
            Debug.out.println();

        } catch (Exception e) {
            e.printStackTrace();
        }

    }
}
