/*
 * shohaku Copyright (C) 2005 tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */
package shohaku.kosho;

import java.io.InputStream;
import java.util.Iterator;

import shohaku.core.lang.ResourceLoader;
import shohaku.core.util.debug.Debug;
import shohaku.core.util.debug.StopWatch;
import shohaku.ginkgo.Document;

/**
 */
public class TestXMLProperties {

    public static void main(String[] args) {

        try {
            XMLProperties xmlProperties = new XMLProperties();

            DefaultKoshoResources properties = null;
            Debug.out.printLine(60);
            Debug.out.printlf(1);
            StopWatch.out.start();

            for (int i = 0; i < 1; i++) {

                InputStream inStream = ResourceLoader.getResourceAsStream("shohaku/kosho/test-xml-properties.xml");
                InputStream inStream2 = ResourceLoader.getResourceAsStream("shohaku/kosho/test-xml-properties2.xml");

                xmlProperties.load(inStream);
                Document parent = xmlProperties.getDocument();
                xmlProperties.load(inStream2, parent);
                properties = new DefaultKoshoResources(xmlProperties);

                Debug.out.printLineln(60);
                for (Iterator j = properties.keyIterator(); j.hasNext();) {
                    String key = (String) j.next();
                    Object value = properties.getObject(key);
                    if (value instanceof TestBean) {
                        Debug.out.println(key, value);
                        Debug.out.printBean(value);
                        Debug.out.println();
                        Debug.out.println(value.getClass());
                    } else {
                        Debug.out.println(key, value);
                        Debug.out.println(value.getClass());
                    }
                }
                Debug.out.printlf(1);
                Debug.out.printLineln(60);
                StopWatch.out.split();

            }
            Debug.out.printLineln(60);
            Debug.out.printlf(1);
            StopWatch.out.stop();
            Debug.out.printlf(1);
            Debug.out.printLine(60);
            Debug.out.printlf(1);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
