/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.collections;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.NoSuchElementException;
import shohaku.core.collections.wrapper.UnmodifiableIterator;
import shohaku.core.collections.wrapper.WrappedIterator;
import shohaku.core.helpers.Eval;
import shohaku.core.lang.Boxing;

public class IteratorUtils {
    public static Iterator compositeIterator(Iterator[] is) {
        return new CompositeIterator(is);
    }

    public static Iterator emptyIterator() {
        return new EmptyIterator();
    }

    public static Iterator arrayIterator(Object a) {
        if (a == null) {
            throw new NullPointerException();
        }
        if (Eval.isArray(a)) {
            Class<?> type = a.getClass().getComponentType();
            if (type.isPrimitive()) {
                if (type == Character.TYPE) {
                    return IteratorUtils.asIterator((char[])a);
                }
                if (type == Boolean.TYPE) {
                    return IteratorUtils.asIterator((boolean[])a);
                }
                if (type == Byte.TYPE) {
                    return IteratorUtils.asIterator((byte[])a);
                }
                if (type == Short.TYPE) {
                    return IteratorUtils.asIterator((short[])a);
                }
                if (type == Integer.TYPE) {
                    return IteratorUtils.asIterator((int[])a);
                }
                if (type == Long.TYPE) {
                    return IteratorUtils.asIterator((long[])a);
                }
                if (type == Float.TYPE) {
                    return IteratorUtils.asIterator((float[])a);
                }
                if (type == Double.TYPE) {
                    return IteratorUtils.asIterator((double[])a);
                }
            } else {
                return IteratorUtils.asIterator((Object[])a);
            }
        }
        throw new IllegalArgumentException("is not Array:" + a);
    }

    public static Iterator asIterator(Object[] a) {
        return new ObjectArrayIterator(a);
    }

    public static Iterator asIterator(char[] a) {
        return new CharacterArrayIterator(a);
    }

    public static Iterator asIterator(boolean[] a) {
        return new BooleanArrayIterator(a);
    }

    public static Iterator asIterator(byte[] a) {
        return new ByteArrayIterator(a);
    }

    public static Iterator asIterator(short[] a) {
        return new ShortArrayIterator(a);
    }

    public static Iterator asIterator(int[] a) {
        return new IntegerArrayIterator(a);
    }

    public static Iterator asIterator(long[] a) {
        return new LongArrayIterator(a);
    }

    public static Iterator asIterator(float[] a) {
        return new FloatArrayIterator(a);
    }

    public static Iterator asIterator(double[] a) {
        return new DoubleArrayIterator(a);
    }

    public static Iterator toStringArrayIterator(Object a) {
        if (a == null) {
            throw new NullPointerException();
        }
        if (Eval.isArray(a)) {
            Class<?> type = a.getClass().getComponentType();
            if (type.isPrimitive()) {
                if (type == Character.TYPE) {
                    return IteratorUtils.asToStringIterator((char[])a);
                }
                if (type == Boolean.TYPE) {
                    return IteratorUtils.asToStringIterator((boolean[])a);
                }
                if (type == Byte.TYPE) {
                    return IteratorUtils.asToStringIterator((byte[])a);
                }
                if (type == Short.TYPE) {
                    return IteratorUtils.asToStringIterator((short[])a);
                }
                if (type == Integer.TYPE) {
                    return IteratorUtils.asToStringIterator((int[])a);
                }
                if (type == Long.TYPE) {
                    return IteratorUtils.asToStringIterator((long[])a);
                }
                if (type == Float.TYPE) {
                    return IteratorUtils.asToStringIterator((float[])a);
                }
                if (type == Double.TYPE) {
                    return IteratorUtils.asToStringIterator((double[])a);
                }
            } else {
                return IteratorUtils.asToStringIterator((Object[])a);
            }
        }
        throw new IllegalArgumentException("is not Array:" + a);
    }

    public static Iterator asToStringIterator(Object[] a) {
        return new ObjectToStringArrayIterator(a);
    }

    public static Iterator asToStringIterator(char[] a) {
        return new CharacterToStringArrayIterator(a);
    }

    public static Iterator asToStringIterator(boolean[] a) {
        return new BooleanToStringArrayIterator(a);
    }

    public static Iterator asToStringIterator(byte[] a) {
        return new ByteToStringArrayIterator(a);
    }

    public static Iterator asToStringIterator(short[] a) {
        return new ShortToStringArrayIterator(a);
    }

    public static Iterator asToStringIterator(int[] a) {
        return new IntegerToStringArrayIterator(a);
    }

    public static Iterator asToStringIterator(long[] a) {
        return new LongToStringArrayIterator(a);
    }

    public static Iterator asToStringIterator(float[] a) {
        return new FloatToStringArrayIterator(a);
    }

    public static Iterator asToStringIterator(double[] a) {
        return new DoubleToStringArrayIterator(a);
    }

    public static Iterator unmodifiableIterator(Iterator i) {
        return new UnmodifiableIterator(i);
    }

    public static Iterator wrappedIterator(Iterator i) {
        return new WrappedIterator(i);
    }

    private static class EmptyIterator
    implements Iterator {
        EmptyIterator() {
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }
    }

    private static abstract class AbstractArrayIterator
    implements Iterator {
        protected final int length;
        protected int index = -1;

        protected AbstractArrayIterator(Object a) {
            if (a == null) {
                throw new NullPointerException();
            }
            this.length = Array.getLength(a);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() {
            if (this.index + 1 < this.length) {
                ++this.index;
                return true;
            }
            return false;
        }

        public Object next() {
            if (this.index < 0) {
                throw new IllegalStateException();
            }
            if (this.index < this.length) {
                return this.nextObject(this.index);
            }
            throw new NoSuchElementException();
        }

        protected abstract Object nextObject(int var1);
    }

    private static class ObjectArrayIterator
    extends AbstractArrayIterator {
        private final Object[] a;

        ObjectArrayIterator(Object[] a) {
            super(a);
            this.a = a;
        }

        protected Object nextObject(int inx) {
            return this.a[inx];
        }
    }

    private static class CharacterArrayIterator
    extends AbstractArrayIterator {
        private final char[] a;

        CharacterArrayIterator(char[] a) {
            super(a);
            this.a = a;
        }

        protected Object nextObject(int inx) {
            return Boxing.box(this.a[inx]);
        }
    }

    private static class BooleanArrayIterator
    extends AbstractArrayIterator {
        private final boolean[] a;

        BooleanArrayIterator(boolean[] a) {
            super(a);
            this.a = a;
        }

        protected Object nextObject(int inx) {
            return Boxing.box(this.a[inx]);
        }
    }

    private static class ByteArrayIterator
    extends AbstractArrayIterator {
        private final byte[] a;

        ByteArrayIterator(byte[] a) {
            super(a);
            this.a = a;
        }

        protected Object nextObject(int inx) {
            return Boxing.box(this.a[inx]);
        }
    }

    private static class ShortArrayIterator
    extends AbstractArrayIterator {
        private final short[] a;

        ShortArrayIterator(short[] a) {
            super(a);
            this.a = a;
        }

        protected Object nextObject(int inx) {
            return Boxing.box(this.a[inx]);
        }
    }

    private static class IntegerArrayIterator
    extends AbstractArrayIterator {
        private final int[] a;

        IntegerArrayIterator(int[] a) {
            super(a);
            this.a = a;
        }

        protected Object nextObject(int inx) {
            return Boxing.box(this.a[inx]);
        }
    }

    private static class LongArrayIterator
    extends AbstractArrayIterator {
        private final long[] a;

        LongArrayIterator(long[] a) {
            super(a);
            this.a = a;
        }

        protected Object nextObject(int inx) {
            return Boxing.box(this.a[inx]);
        }
    }

    private static class FloatArrayIterator
    extends AbstractArrayIterator {
        private final float[] a;

        FloatArrayIterator(float[] a) {
            super(a);
            this.a = a;
        }

        protected Object nextObject(int inx) {
            return Boxing.box(this.a[inx]);
        }
    }

    private static class DoubleArrayIterator
    extends AbstractArrayIterator {
        private final double[] a;

        DoubleArrayIterator(double[] a) {
            super(a);
            this.a = a;
        }

        protected Object nextObject(int inx) {
            return Boxing.box(this.a[inx]);
        }
    }

    private static class ObjectToStringArrayIterator
    extends AbstractArrayIterator {
        private final Object[] a;

        ObjectToStringArrayIterator(Object[] a) {
            super(a);
            this.a = a;
        }

        protected Object nextObject(int inx) {
            return String.valueOf(this.a[inx]);
        }
    }

    private static class CharacterToStringArrayIterator
    extends AbstractArrayIterator {
        private final char[] a;

        CharacterToStringArrayIterator(char[] a) {
            super(a);
            this.a = a;
        }

        protected Object nextObject(int inx) {
            return String.valueOf(this.a[inx]);
        }
    }

    private static class BooleanToStringArrayIterator
    extends AbstractArrayIterator {
        private final boolean[] a;

        BooleanToStringArrayIterator(boolean[] a) {
            super(a);
            this.a = a;
        }

        protected Object nextObject(int inx) {
            return String.valueOf(this.a[inx]);
        }
    }

    private static class ByteToStringArrayIterator
    extends AbstractArrayIterator {
        private final byte[] a;

        ByteToStringArrayIterator(byte[] a) {
            super(a);
            this.a = a;
        }

        protected Object nextObject(int inx) {
            return String.valueOf(this.a[inx]);
        }
    }

    private static class ShortToStringArrayIterator
    extends AbstractArrayIterator {
        private final short[] a;

        ShortToStringArrayIterator(short[] a) {
            super(a);
            this.a = a;
        }

        protected Object nextObject(int inx) {
            return String.valueOf(this.a[inx]);
        }
    }

    private static class IntegerToStringArrayIterator
    extends AbstractArrayIterator {
        private final int[] a;

        IntegerToStringArrayIterator(int[] a) {
            super(a);
            this.a = a;
        }

        protected Object nextObject(int inx) {
            return String.valueOf(this.a[inx]);
        }
    }

    private static class LongToStringArrayIterator
    extends AbstractArrayIterator {
        private final long[] a;

        LongToStringArrayIterator(long[] a) {
            super(a);
            this.a = a;
        }

        protected Object nextObject(int inx) {
            return String.valueOf(this.a[inx]);
        }
    }

    private static class FloatToStringArrayIterator
    extends AbstractArrayIterator {
        private final float[] a;

        FloatToStringArrayIterator(float[] a) {
            super(a);
            this.a = a;
        }

        protected Object nextObject(int inx) {
            return String.valueOf(this.a[inx]);
        }
    }

    private static class DoubleToStringArrayIterator
    extends AbstractArrayIterator {
        private final double[] a;

        DoubleToStringArrayIterator(double[] a) {
            super(a);
            this.a = a;
        }

        protected Object nextObject(int inx) {
            return String.valueOf(this.a[inx]);
        }
    }

    private static class CompositeIterator
    implements Iterator {
        final Iterator[] iters;
        private Iterator i;
        private int index = -1;

        CompositeIterator(Iterator[] is) {
            this.iters = is;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() {
            while (this.i == null || !this.i.hasNext()) {
                ++this.index;
                if (this.index >= this.iters.length) break;
                this.i = this.iters[this.index];
            }
            return this.i.hasNext();
        }

        public Object next() {
            return this.i.next();
        }
    }
}

