/*
 * Decompiled with CFR 0.152.
 */
package shohaku.core.collections.group;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import shohaku.core.collections.Group;
import shohaku.core.collections.wrapper.UnmodifiableCollection;

public class SingletonGroup
implements Group,
Serializable {
    private static final long serialVersionUID = 1874733670601283635L;
    private final Group.Entry entry;
    private transient Set keySet = null;
    private transient Set entrySet = null;

    public SingletonGroup(Object key, Collection values) {
        this.entry = new SingletonEntry(key, new ArrayList(values));
    }

    public boolean add(Object key) {
        throw new UnsupportedOperationException();
    }

    public boolean add(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    public void addAll(Group g) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(Object key, Collection c) {
        throw new UnsupportedOperationException();
    }

    public Collection remove(Object key) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = Collections.singleton(this.entry.getKey());
        }
        return this.keySet;
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = Collections.singleton(this.entry);
        }
        return this.entrySet;
    }

    public Collection get(Object key) {
        return this.entry.getKey().equals(key) ? this.entry.getValues() : null;
    }

    public Iterator iterator() {
        return this.entrySet().iterator();
    }

    public Iterator iterator(Object key) {
        return this.entry.getKey().equals(key) ? this.entry.getValues().iterator() : null;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean containsKey(Object key) {
        return this.entry.getKey().equals(key);
    }

    public boolean containsValue(Object key, Object value) {
        return this.entry.getKey().equals(key) && this.entry.getValues().contains(value);
    }

    public int size() {
        return 1;
    }

    public int size(Object key) {
        return this.entry.getKey().equals(key) ? this.entry.getValues().size() : 0;
    }

    public int hashCode() {
        return this.entry.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Group)) {
            return false;
        }
        Group t = (Group)o;
        if (t.size() != this.size()) {
            return false;
        }
        return this.entrySet().equals(t.entrySet());
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        buf.append(this.entry.getKey());
        buf.append('=');
        buf.append(this.entry.getValues());
        buf.append("}");
        return buf.toString();
    }

    private class SingletonEntry
    implements Group.Entry,
    Serializable {
        private static final long serialVersionUID = -787602226179661703L;
        private final Object key;
        private final Collection values;

        SingletonEntry(Object key, Collection values) {
            this.key = key;
            this.values = new UnmodifiableCollection(values);
        }

        public Object getKey() {
            return this.key;
        }

        public Collection getValues() {
            return this.values;
        }

        public int hashCode() {
            return this.key.hashCode() + this.values.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof Group.Entry)) {
                return false;
            }
            Group.Entry e = (Group.Entry)o;
            return this.key.equals(e.getKey()) && this.values.equals(e.getValues());
        }

        public String toString() {
            return this.key + "=" + this.values;
        }
    }
}

