/*
 * shohaku Copyright (C) 2005 tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */
package shohaku.ginkgo.nodes.core.beans;

import java.util.ArrayList;
import java.util.Iterator;

import shohaku.core.beans.FactoryMethodInfo;
import shohaku.core.beans.InvocationBeansException;
import shohaku.core.beans.MethodInfo;
import shohaku.core.lang.NoSuchResourceException;
import shohaku.core.lang.ObjectCreationException;
import shohaku.core.lang.ResourceLoader;
import shohaku.ginkgo.GinkgoException;
import shohaku.ginkgo.Node;
import shohaku.ginkgo.nodes.AbstractValueNode;

/**
 * オブジェクトを生成する値型の汎用ノードを提供します。
 */
public class ObjectNode extends AbstractValueNode {

    /**
     * 値を生成して返却します。
     * 
     * @return 生成された値
     */
    protected Object generateValue() {

        // load class
        String className = this.getAttribute("class", "java.lang.Object");
        final Class objectClass;
        try {
            objectClass = ResourceLoader.getClass(className, getContext().getClassLoader());
        } catch (NoSuchResourceException e) {
            throw new GinkgoException("illegal class name is specified. " + className, e);
        }

        // get MethodInfo's
        Object obj = null;
        FactoryMethodInfo factory = null;
        ArrayList methods = new ArrayList();
        for (Iterator i = getContext().valueElementIterator(); i.hasNext();) {
            Node n = (Node) i.next();
            Object o = n.getNodeValue();
            if (o == null || !(o instanceof MethodInfo || o instanceof FactoryMethodInfo)) {
                throw new GinkgoException("element is illegal. MethodInfo or ConstructorInfo is right. element:" + o);
            }
            if (o instanceof FactoryMethodInfo) {
                if (factory != null) {
                    throw new GinkgoException("FactoryMethodInfo except for one is illegal. element:" + o);
                }
                factory = (FactoryMethodInfo) o;
            } else {
                methods.add(o);
            }
        }

        // invoke MethodInfo
        try {

            if (factory != null) {
                if (null == factory.getObjectType()) {
                    obj = factory.invoke(objectClass);
                } else {
                    obj = factory.invoke();
                }
            } else {
                obj = ResourceLoader.getInstance(objectClass);
            }

            for (Iterator i = methods.iterator(); i.hasNext();) {
                MethodInfo mi = (MethodInfo) i.next();
                mi.invoke(obj);
            }
        } catch (ObjectCreationException e) {
            throw new GinkgoException("object creative error. :" + objectClass, e);
        } catch (InvocationBeansException e) {
            throw new GinkgoException("object creative error. :" + objectClass, e);
        }
        return obj;
    }

}
