/*
 * shohaku Copyright (C) 2005 tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */
package shohaku.ginkgo;

import shohaku.core.collections.params.Parameters;
import shohaku.core.collections.params.ParametersUtils;

/**
 * 個々のXMLノードの構成ルールを表現する機能を提供します。
 */
public final class NodeRule {

    /* マッピングするXML階層URIの書式パターン。 */
    private String pattern;

    /* 生成するノードのクラス名。 */
    private String nodeClass;

    /* 属性のデフォルト値のパラメータリスト。 */
    private Parameters nodeAttributesRules;

    /* 拡張属性のパラメータリスト。 */
    private Parameters xAttributes;

    /* ノードの属性やテキスト文字列を代入する機能。 */
    private Substitutor substitutor;

    /**
     * ノードのクラス名を返却します。
     * 
     * @return ノードのクラス名
     */
    public String getNodeClass() {
        return nodeClass;
    }

    /**
     * ノードのクラス名を格納します。
     * 
     * @param cname
     *            ノードのクラス名
     */
    public void setNodeClass(String cname) {
        this.nodeClass = cname;
    }

    /**
     * 属性の構成ルールのパラメータリストを返却します。
     * 
     * @return 属性の構成ルールのパラメータリスト
     */
    public Parameters getNodeAttributesRules() {
        return (nodeAttributesRules != null) ? nodeAttributesRules : ParametersUtils.EMPTY_PARAMETERS;
    }

    /**
     * 属性の構成ルールのパラメータリストを格納します。
     * 
     * @param rules
     *            属性の構成ルールのパラメータリスト
     */
    public void setNodeAttributesRules(Parameters rules) {
        this.nodeAttributesRules = rules;
    }

    /**
     * 拡張属性のパラメータリストを返却します。
     * 
     * @return 拡張属性のパラメータリスト。
     */
    public Parameters getXAttributes() {
        return (xAttributes != null) ? xAttributes : ParametersUtils.EMPTY_PARAMETERS;
    }

    /**
     * 拡張属性のパラメータリストを格納します。
     * 
     * @param xAttributes
     *            拡張属性のパラメータリスト。
     */
    public void setXAttributes(Parameters xAttributes) {
        this.xAttributes = xAttributes;
    }

    /**
     * XML階層URIの書式パターンを返却します。
     * 
     * @return XML階層URIの書式パターン
     */
    public String getPattern() {
        return pattern;
    }

    /**
     * XML階層URIの書式パターンを格納します。
     * 
     * @param pattern
     *            XML階層URIの書式パターン
     */
    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    /**
     * ノードの属性やテキスト文字列を代入するオブジェクトを返却します。
     * 
     * @return Substitutor
     */
    public Substitutor getSubstitutor() {
        return substitutor;
    }

    /**
     * ノードの属性やテキスト文字列を代入するオブジェクトを格納します。
     * 
     * @param substitutor
     *            Substitutor
     */
    public void setSubstitutor(Substitutor substitutor) {
        this.substitutor = substitutor;
    }
}