/*
 * shohaku Copyright (C) 2005 tomoya nagatani
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */
package shohaku.ginkgo.nodes.core.collection;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

import shohaku.core.lang.ObjectCreationException;
import shohaku.core.lang.ResourceLoader;
import shohaku.ginkgo.GinkgoException;
import shohaku.ginkgo.Node;
import shohaku.ginkgo.nodes.AbstractValueNode;

/**
 * マップ型のデータを生成する値型のノードを提供します。
 */
public class MapNode extends AbstractValueNode {

    /**
     * 値を生成して返却します。
     * 
     * @return 生成された値
     */
    protected Object generateValue() {

        String type = getAttribute("type", "java.util.LinkedHashMap");
        Map m;
        try {
            m = (Map) ResourceLoader.getInstance(type, getContext().getClassLoader());
        } catch (ClassCastException e) {
            throw new GinkgoException("class name which is not a Map class is specified. " + type, e);
        } catch (ObjectCreationException e) {
            throw new GinkgoException("illegal class name is specified. " + type, e);
        }

        for (Iterator i = getContext().valueElementIterator(); i.hasNext();) {
            Node arg = (Node) i.next();
            m.putAll((Map) arg.getNodeValue());
        }

        return Collections.unmodifiableMap(m);
    }

}
