/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.ginkgo;

/**
 * 子のエレメントの集合の役割を持つコンテナタグのインターフェースを提供します。
 */
public interface ContainTag {

    /** コンテナ内のIDスコープ：ドキュメントの可視領域全域で公開する。 */
    int SCOPE_PUBLIC = 100;

    /** コンテナ内のIDスコープ：ドキュメント内およびインスタンスの所有者。 */
    int SCOPE_OWNER = 101;

    /** コンテナ内のIDスコープ：ドキュメント内のみ。 */
    int SCOPE_DOCUMENT = 102;

    /**
     * コンテナのスコープを返却します。
     * 
     * @return コンテナのスコープ
     */
    int getScope();

}
