/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.ginkgo;

/**
 * XMLドキュメントを構造化されたオブジェクトに変換する過程で、何らかの誤りが発見された事を示す例外を提供します。<br>
 * この例外は広範囲な障害の要因を含む、包括性の高い例外として定義されています。<br>
 * そのため起因となる例外は可能な限り、起因例外にキャッシュする事が要求されます。
 */
public class GinkgoException extends RuntimeException {

    /* serialVersionUID */
    private static final long serialVersionUID = -8130052704183494091L;

    /**
     * デフォルトコンストラクタ。
     */
    public GinkgoException() {
        super();
    }

    /**
     * エラーメッセージを設定して初期化します。
     * 
     * @param message
     *            エラーメッセージ
     */
    public GinkgoException(String message) {
        super(message);
    }

    /**
     * 起因例外を設定して初期化します。
     * 
     * @param cause
     *            起因例外
     */
    public GinkgoException(Throwable cause) {
        super(cause);
    }

    /**
     * エラーメッセージと起因例外を設定して初期化します。
     * 
     * @param message
     *            エラーメッセージ
     * @param cause
     *            起因例外
     */
    public GinkgoException(String message, Throwable cause) {
        super(message, cause);
    }

}
