/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.ginkgo;

/**
 * XMLドキュメントのノードを構造化されたオブジェクトに合成するルールを提供します。
 */
public interface NodeCompositeRule {

    /**
     * ノードの構成情報を返却します。
     * 
     * @param namespaceURI
     *            解析対象の名前空間URI
     * @param nodeURI
     *            解析対象のXML階層URI
     * @param tagName
     *            タグ名
     * @return ノード構成情報
     */
    TagRule findTagRule(String namespaceURI, String nodeURI, String tagName);

    /**
     * 名前空間URI単位で、タグ構成ルールの集合を格納します。
     * 
     * @param namespaceURI
     *            タグの名前空間URI
     * @param tagRuleSet
     *            タグ構成ルールの集合
     */
    void addTagRule(String namespaceURI, TagRuleSet tagRuleSet);

    /**
     * 指定された識別子が示す拡張機能を返却します。 <br>
     * 指定された識別子に対応する拡張機能が存在しない場合 null を返却します。
     * 
     * @param id
     *            機能を示すクラス
     * @return 拡張機能
     */
    Object getFeature(Class id);

    /**
     * 指定された識別子が示す構造化処理の拡張機能を追加します。
     * 
     * @param id
     *            機能を示すクラス
     * @param feature
     *            拡張機能
     */
    void addFeature(Class id, Object feature);

    /**
     * タグ属性をタグのプロパティに転送する機能を返却します。
     * 
     * @return タグ属性をタグのプロパティに転送する機能
     */
    TagPropertyTransfer getTagPropertyTransfer();

    /**
     * タグ属性をタグのプロパティに転送する機能を返却します。
     * 
     * @param tagPropertyTransfer
     *            タグ属性をタグのプロパティに転送する機能
     */
    void setTagPropertyTransfer(TagPropertyTransfer tagPropertyTransfer);

    /**
     * 解析処理の直前に呼び出されます、処理のフックポイントの役割を持ちます。
     * 
     * @param ginkgo
     *            解析処理を実行する Ginkgo
     */
    void prepare(Ginkgo ginkgo);
}
