/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.ginkgo;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/**
 * タグ属性の構成ルールの集合を表現する機能を提供します。
 */
public class TagAttributesRuleSet {

    /* 空データのタグ属性構成ルールの集合 */
    static final TagAttributesRuleSet EMPTY_RULESET = new TagAttributesRuleSet();

    /* タグ属性の構成ルールの配列 */
    private Map lookup;

    /**
     * 空データで初期化します。
     */
    public TagAttributesRuleSet() {
        this(Collections.EMPTY_SET, Collections.EMPTY_MAP);
    }

    /**
     * タグ属性の構成ルールのコレクションを格納して初期化します。
     * 
     * @param tagAttributesRules
     *            タグ属性の構成ルールのコレクション
     */
    public TagAttributesRuleSet(Collection tagAttributesRules) {
        this(tagAttributesRules, new HashMap());
    }

    /* タグ属性の構成ルールのコレクションを指定のマップに名前をキーとして格納して初期化します。 */
    private TagAttributesRuleSet(Collection tagAttributesRules, Map lookupMap) {
        for (Iterator i = tagAttributesRules.iterator(); i.hasNext();) {
            TagAttributesRule rule = (TagAttributesRule) i.next();
            lookupMap.put(rule.getName(), rule);
        }
        this.lookup = lookupMap;
    }

    /**
     * タグ属性の構成ルールの反復子を返却します。
     * 
     * @return タグ属性の構成ルールの反復子
     */
    public Iterator iterator() {
        return lookup.values().iterator();
    }

    /**
     * 指定の名前を持つタグ属性の構成ルールを検索して返却します。
     * 
     * @param name
     *            属性名
     * @return タグ属性の構成ルール
     */
    public TagAttributesRule find(String name) {
        return (TagAttributesRule) lookup.get(name);
    }

}
