/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.ginkgo;

/**
 * タグのプロパティにタグ属性を転送する機能を提供します。
 */
public interface TagPropertyTransfer {

    /**
     * タグ属性値を代入します。
     * 
     * @param document
     *            ドキュメント
     * @param atts
     *            タグ属性
     */
    void substitut(Document document, TagAttributes atts);

    /**
     * タグにテキストを代入します。
     * 
     * @param document
     *            ドキュメント
     * @param text
     *            テキスト
     */
    void substitut(Document document, StringBuffer text);

    /**
     * タグのプロパティにタグ属性を設定します。<br>
     * タグが 属性名に対応する setter メソッドを定義する場合は実行します。
     * 
     * @param tag
     *            タグ
     */
    void setAttributes(TagNode tag);

    /**
     * タグのプロパティにテキストを変換して設定します。<br>
     * タグが setTextTransferValue メソッドを定義すると同時に、<br>
     * タグに本体が有り、本体に子のエレメントが無い場合は実行します。
     * 
     * @param tag
     *            タグ
     */
    void setText(TagNode tag);

    /**
     * タグのプロパティに要素タグの値を設定します。<br>
     * タグが要素タグ名（プレフィックスを含まない）に対応する、接頭辞 add を持つメソッドを定義する場合に実行します。<br>
     * 或いはタグが addElementTransferValue メソッドを定義する場合はデフォルトメソッドとして実行します。<br>
     * 接尾辞を持つメソッドやデフォルトメソッドはオーバーロード可能です。
     * 
     * @param tag
     *            タグ
     * @param element
     *            追加する要素タグ
     */
    void addElement(TagNode tag, TagNode element);

}
