/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.ginkgo;

/**
 * 個々のタグの構成ルールを表現する機能を提供します。
 */
public final class TagRule {

    /* マッピングするXML階層URIの書式パターン。 */
    private String pattern;

    /* 生成するノードのクラス名。 */
    private String tagClass;

    /* 属性のデフォルト値のパラメータリスト。 */
    private TagAttributesRuleSet tagAttributesRuleSet;

    /**
     * ノードのクラス名を返却します。
     * 
     * @return ノードのクラス名
     */
    public String getTagClass() {
        return tagClass;
    }

    /**
     * ノードのクラス名を格納します。
     * 
     * @param cname
     *            ノードのクラス名
     */
    public void setTagClass(String cname) {
        this.tagClass = cname;
    }

    /**
     * 属性の構成ルールのパラメータリストを返却します。
     * 
     * @return 属性の構成ルールのパラメータリスト
     */
    public TagAttributesRuleSet getTagAttributesRuleSet() {
        return (tagAttributesRuleSet == null) ? TagAttributesRuleSet.EMPTY_RULESET : tagAttributesRuleSet;
    }

    /**
     * 属性の構成ルールのパラメータリストを格納します。
     * 
     * @param ruleSet
     *            属性の構成ルールのパラメータリスト
     */
    public void setTagAttributesRuleSet(TagAttributesRuleSet ruleSet) {
        this.tagAttributesRuleSet = ruleSet;
    }

    /**
     * XML階層URIの書式パターンを返却します。
     * 
     * @return XML階層URIの書式パターン
     */
    public String getPattern() {
        return pattern;
    }

    /**
     * XML階層URIの書式パターンを格納します。
     * 
     * @param pattern
     *            XML階層URIの書式パターン
     */
    public void setPattern(String pattern) {
        this.pattern = pattern;
    }
}