/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.ginkgo;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

import shohaku.core.collections.IteratorUtils;

/**
 * タグの構成ルールの集合を表現する機能を提供します。
 */
public class TagRuleSet {

    /* タグ構成ルールの配列 */
    private TagRule[] lookup;

    /**
     * 空データで初期化します。
     */
    public TagRuleSet() {
        this(Collections.EMPTY_LIST);
    }

    /**
     * タグ構成ルールのコレクションを格納して初期化します。<br>
     * コレクションの反復子の順序が保持されます。
     * 
     * @param tagRules
     *            タグ構成ルールのコレクション
     */
    public TagRuleSet(Collection tagRules) {
        this.lookup = (TagRule[]) tagRules.toArray(new TagRule[tagRules.size()]);
    }

    /**
     * タグ構成ルールの反復子を返却します。
     * 
     * @return タグ構成ルールの反復子
     */
    public Iterator iterator() {
        return IteratorUtils.arrayIterator(lookup);
    }
}
