/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.ginkgo;

/**
 * テキストノードの実装を提供します。このクラスはシステム内部でのみ生成されます。
 */
class TextNodeImpl implements TextNode {

    /* テキスト. */
    private String text;

    /**
     * 空テキストで初期化します。
     */
    public TextNodeImpl() {
        this("");
    }

    /**
     * テキストを格納して初期化します。
     * 
     * @param text
     *            テキスト
     */
    public TextNodeImpl(String text) {
        this.text = text;
    }

    /**
     * テキストを返却します。
     * 
     * @return テキスト
     */
    public Object getNodeValue() {
        return text;
    }

    /**
     * このノードのテキストをそのまま返却します。
     * 
     * @return テキスト情報
     */
    public String getText() {
        return text;
    }

}
