/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
/**
 * 
 */
package shohaku.ginkgo.rule;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import shohaku.core.collections.IteratorUtils;
import shohaku.core.lang.Eval;
import shohaku.core.lang.Predicate;
import shohaku.ginkgo.Document;
import shohaku.ogdl.OgdlContext;
import shohaku.ogdl.OgdlContextMixIn;

/**
 * OGDL式のコンテキストの実装を提供します。
 */
class OgdlContextImpl implements OgdlContext {

    private final OgdlContextMixIn mixIn;

    private final Document document;

    /**
     * 初期化します。
     * 
     * @param doc
     *            銀杏ドキュメント
     */
    OgdlContextImpl(Document doc) {
        this.document = doc;
        this.mixIn = new OgdlContextMixIn(null, null, new HashMap(0));
    }

    public boolean addImport(Class c) {
        return document.getContext().addImport(c);
    }

    public Class forImport(String name) {
        return document.getContext().forClass(name);
    }

    public void addFunctionsMap(String prefix, Map functionsMap) {
        this.mixIn.addFunctionsMap(prefix, functionsMap);
    }

    public Collection forFunctions(String name) {
        return this.mixIn.forFunctions(name);
    }

    public Iterator attributeNames() {
        final Map refMap = document.getTagValueMapView();
        final Map sttMap = document.getContext().getAttributeMapView();
        Iterator[] iters = new Iterator[2];
        iters[0] = refMap.keySet().iterator();
        iters[0] = IteratorUtils.predicateIterator(sttMap.keySet().iterator(), new Predicate() {
            public boolean evaluate(Object o) {
                return (!refMap.containsKey(o));
            }
        });
        return IteratorUtils.compositeIterator(iters);
    }

    public Object getAttribute(String name) {
        if (!Eval.isBlank(name)) {
            if (document.containsId(name)) {
                return TypeTransformHelper.getReferenceValue(document, name);
            } else {
                return document.getContext().getAttribute(name);
            }
        }
        return null;
    }

    public void setAttribute(String name, Object value) {
        document.getContext().setAttribute(name, value);
    }

    public Object removeAttribute(String name) {
        return document.getContext().removeAttribute(name);
    }

    public boolean containsAttribute(String name) {
        boolean contains = false;
        if (!Eval.isEmpty(name)) {
            contains = document.containsId(name);
            if (!contains) {
                contains = document.getContext().containsName(name);
            }
        }
        return contains;
    }

    public ClassLoader getClassLoader() {
        return mixIn.getClassLoader();
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.mixIn.setClassLoader(classLoader);
    }

}