/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.ginkgo.tags;

import shohaku.ginkgo.GinkgoException;
import shohaku.ginkgo.TagContext;
import shohaku.ginkgo.TagNode;
import shohaku.ginkgo.TextNode;

/**
 * タグの抽象実装を提供し実装の負担を最小化します。
 */
public abstract class AbstractTag implements TagNode {

    /* タグのコンテキスト情報 */
    private TagContext tagContext;

    public final String getId() {
        return tagContext.getAttribute("id");
    }

    public final String getName() {
        return tagContext.getAttribute("name");
    }

    public TagContext getTagContext() {
        return tagContext;
    }

    /**
     * 解析処理を開始する直前に初期化の通知を受ける。 <br>
     * オーバライドした場合必ず親クラスの同メソッドを呼び出してください。
     * 
     * @param context
     *            タグのコンテキスト情報
     * @throws GinkgoException
     *             構成情報例外
     */
    public void initialize(TagContext context) {
        this.tagContext = context;
    }

    /**
     * 空実装です。
     * 
     * @throws GinkgoException
     *             構成情報例外
     * @see shohaku.ginkgo.TagNode#begin()
     */
    public void begin() {
        // no op
    }

    /**
     * 空実装です。
     * 
     * @param tagNode
     *            子のノード
     * @throws GinkgoException
     *             構成情報例外
     * @see shohaku.ginkgo.TagNode#child(shohaku.ginkgo.TagNode)
     */
    public void child(TagNode tagNode) {
        // no op
    }

    /**
     * 空実装です。
     * 
     * @param textNode
     *            テキストノード
     * @throws GinkgoException
     *             構成情報例外
     * @see shohaku.ginkgo.TagNode#text(shohaku.ginkgo.TextNode)
     */
    public void text(TextNode textNode) {
        // no op
    }

    /**
     * 空実装です。
     * 
     * @throws GinkgoException
     *             構成情報例外
     * @see shohaku.ginkgo.TagNode#end()
     */
    public void end() {
        // no op
    }

    /**
     * 空実装です。
     * 
     * @throws GinkgoException
     *             構成情報例外
     * @see shohaku.ginkgo.TagNode#finish()
     */
    public void finish() {
        // no op
    }

}
