/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.ginkgo.tags;

import shohaku.ginkgo.GinkgoException;
import shohaku.ginkgo.ValueNode;

/**
 * デフォルトの値ノードの抽象実装を提供し実装の負担を最小化します。
 */
public abstract class AbstractValueTag extends AbstractTag implements ValueNode {

    /* 値をキャッシュします。 */
    protected Object cacheValue;

    /**
     * ノードの値表現を返却します。
     * 
     * @return ノードの値表現
     */
    public Object getNodeValue() {
        return this.cacheValue;
    }

    /**
     * タグ解析終了通知を受け値生成を実行して結果をキャッシュします。<br>
     * オーバライドした場合必ず親クラスの同メソッドを呼び出してください。
     * 
     * @throws GinkgoException
     *             構成情報例外
     */
    public void end() {
        this.cacheValue = generateValue();
    }

    /**
     * 値を生成して返却します。
     * 
     * @return 生成された値
     * @throws GinkgoException
     *             構成情報例外
     */
    abstract protected Object generateValue();

}
