/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.ginkgo.tags;

import shohaku.ginkgo.ContainTag;

/**
 * クラス型の属性を持つ、 ContainTag.SCOPE_PUBLIC のスコープを持つコンテナを提供します。<br>
 * クラスと関連づけられるコンテナです。
 */
public class ClassContainTag extends AbstractTag implements ContainTag {

    private Class type = null;

    /**
     * コンテナのスコープ (SCOPE_PUBLIC) を返却します。
     * 
     * @return コンテナのスコープ
     */
    public int getScope() {
        return SCOPE_PUBLIC;
    }

    /**
     * クラス型を返却します。
     * 
     * @return クラス型
     */
    public Class getType() {
        return type;
    }

    /**
     * クラス型を格納します。
     * 
     * @param type
     *            クラス型
     */
    public void setType(Class type) {
        this.type = type;
    }

}
