/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.ginkgo.tags.core.base;

import shohaku.ginkgo.tags.AbstractValueTag;

/**
 * 文字列型のデータを表す値タグを提供します。 <br>
 * <br>
 * 値の生成規則： <br>
 * 値型の子エレメントが存在する場合は、全ての子エレメントの値を文字列として連結して値とします。 <br>
 * 値型の子エレメントが存在しない場合は、テキストを値とします。 <br>
 * <br>
 */
public class StringTag extends AbstractValueTag {

    private StringBuffer value = new StringBuffer();

    /**
     * 値を生成して返却します。
     * 
     * @return 生成された値
     */
    protected Object generateValue() {
        return value.toString();
    }

    /**
     * 変換されたテキストを格納します。
     * 
     * @param textValue
     *            変換されたテキスト
     */
    public void setTextTransferValue(String textValue) {
        this.value.append(textValue);
    }

    /**
     * エレメントを追加します。
     * 
     * @param element
     *            エレメント
     */
    public void addElementTransferValue(Object element) {
        this.value.append(element);
    }

}
