/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.ginkgo.tags.core.base;

import shohaku.ginkgo.tags.AbstractValueTag;

/**
 * value 属性のオブジェクト型のデータを表す値タグを提供します。 <br>
 * <br>
 * 値の生成規則： <br>
 * value 属性の値をオブジェクトとして値とします。 <br>
 * 属性の指定が無い場合は初期値 null を値とします。 <br>
 */
public class ValueTag extends AbstractValueTag {

    private Object value;

    /**
     * 値を生成して返却します。
     * 
     * @return 生成された値
     */
    protected Object generateValue() {
        return value;
    }

    /**
     * value 属性を格納します。
     * 
     * @param value
     *            value 属性
     */
    public void setValue(Object value) {
        this.value = value;
    }

    /**
     * value 属性を返却します。
     * 
     * @return value 属性
     */
    public Object getValue() {
        return this.value;
    }

}
