/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.ginkgo.tags.core.beans;

import java.util.LinkedList;
import java.util.List;

import shohaku.core.beans.dynamic.ArgumentDesc;
import shohaku.core.beans.dynamic.ArgumentsDesc;
import shohaku.core.helpers.HBeans;
import shohaku.core.lang.Eval;
import shohaku.core.lang.IntrospectionBeansException;
import shohaku.ginkgo.GinkgoException;
import shohaku.ginkgo.tags.AbstractValueTag;

/**
 * メソッドを呼び出し戻り値を返す値タグを提供します。
 */
public class CallMethodTag extends AbstractValueTag {

    private String method = null;

    private Class clazz = null;

    private Object ref = null;

    private final List args = new LinkedList();

    /**
     * 値を生成して返却します。
     * 
     * @return 生成された値
     */
    protected Object generateValue() {

        if (Eval.isBlank(method)) {
            throw new GinkgoException("blank method name.");
        }

        Class objectType = clazz;
        Object object = ref;

        if (objectType == null) {
            if (object == null) {
                throw new GinkgoException("reference id doesn't exist.");
            }
            objectType = object.getClass();
        }

        ArgumentsDesc argsDesc = new ArgumentsDesc((ArgumentDesc[]) args.toArray(new ArgumentDesc[0]));
        Class[] parameterTypes = argsDesc.getArgumentTypes();
        Object[] parameterValues = argsDesc.getArgumentValues();

        try {
            return HBeans.invokeMethod(object, HBeans.getAssignmentMethod(objectType, method, parameterTypes), parameterValues);
        } catch (IntrospectionBeansException e) {
            throw new GinkgoException("illegal method. ", e);
        }
    }

    /**
     * method 属性を格納します。
     * 
     * @param method
     *            method 属性
     */
    public void setMethod(String method) {
        this.method = method;
    }

    /**
     * class 属性を格納します。
     * 
     * @param clazz
     *            class 属性
     */
    public void setClazz(Class clazz) {
        this.clazz = clazz;
    }

    /**
     * clazz 属性を返却します。
     * 
     * @return clazz 属性
     */
    public Class getClazz() {
        return this.clazz;
    }

    /**
     * method 属性を返却します。
     * 
     * @return method 属性
     */
    public String getMethod() {
        return this.method;
    }

    /**
     * ref 属性を返却します。
     * 
     * @return ref 属性
     */
    public Object getRef() {
        return this.ref;
    }

    /**
     * ref 属性を格納します。
     * 
     * @param ref
     *            ref 属性
     */
    public void setRef(Object ref) {
        this.ref = ref;
    }

    /**
     * エレメントを追加します。
     * 
     * @param arg
     *            エレメント
     */
    public void addElementTransferValue(ArgumentDesc arg) {
        args.add(arg);
    }

}
