/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.ginkgo.tags.core.beans;

import shohaku.core.helpers.HBeans;
import shohaku.core.lang.IntrospectionBeansException;
import shohaku.ginkgo.GinkgoException;
import shohaku.ginkgo.tags.AbstractValueTag;

/**
 * クラスの全ての定数フィールド（public static final なフィールド）を、マップに格納して返す値タグを提供します。
 */
public class ConstantFieldsMapTag extends AbstractValueTag {

    private Class clazz = null;

    /**
     * 値を生成して返却します。
     * 
     * @return 生成された値
     */
    protected Object generateValue() {
        if (null == clazz) {
            throw new GinkgoException("class doesn't exist.");
        }
        try {
            return HBeans.getConstantFieldMap(clazz);
        } catch (IntrospectionBeansException e) {
            throw new GinkgoException("field access error.", e);
        }
    }

    /**
     * class 属性を格納します。
     * 
     * @param clazz
     *            class 属性
     */
    public void setClazz(Class clazz) {
        this.clazz = clazz;
    }

    /**
     * clazz 属性を返却します。
     * 
     * @return clazz 属性
     */
    public Class getClazz() {
        return this.clazz;
    }

}
