/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.ginkgo.tags.core.beans;

import java.util.LinkedList;
import java.util.List;

import shohaku.core.beans.dynamic.ArgumentDesc;
import shohaku.core.beans.dynamic.ArgumentsDesc;
import shohaku.core.beans.dynamic.FactoryMethodDesc;
import shohaku.core.lang.Eval;
import shohaku.ginkgo.tags.AbstractValueTag;

/**
 * コンストラクタまたはファクトリメソッドを表現する値タグを提供します。shohaku.core.beans.FactoryMethodDesc 型のデータを生成します。
 */
public class FactoryMethodDescTag extends AbstractValueTag {

    private String method = null;

    private final List args = new LinkedList();

    /**
     * 値を生成して返却します。
     * 
     * @return 生成された値
     */
    protected Object generateValue() {

        ArgumentsDesc argsDesc = new ArgumentsDesc((ArgumentDesc[]) args.toArray(new ArgumentDesc[0]));

        FactoryMethodDesc factory = null;
        if (!Eval.isBlank(method)) {
            factory = new FactoryMethodDesc(method, argsDesc);
        } else {
            factory = new FactoryMethodDesc(argsDesc);
        }

        return factory;
    }

    /**
     * method 属性を格納します。
     * 
     * @param method
     *            method 属性
     */
    public void setMethod(String method) {
        this.method = method;
    }

    /**
     * method 属性を返却します。
     * 
     * @return method 属性
     */
    public String getMethod() {
        return this.method;
    }

    /**
     * エレメントを追加します。
     * 
     * @param arg
     *            エレメント
     */
    public void addElementTransferValue(ArgumentDesc arg) {
        args.add(arg);
    }
}