/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.ginkgo.tags.core.beans;

import java.util.LinkedList;
import java.util.List;

import shohaku.core.beans.dynamic.ArgumentDesc;
import shohaku.core.beans.dynamic.ArgumentsDesc;
import shohaku.core.beans.dynamic.MethodDesc;
import shohaku.core.lang.Eval;
import shohaku.ginkgo.GinkgoException;
import shohaku.ginkgo.tags.AbstractValueTag;

/**
 * メソッドを表現する値タグを提供します。MethodDesc.METHOD を持つ shohaku.core.beans.MethodDesc 型のデータを生成します。
 */
public class MethodDescTag extends AbstractValueTag {

    private final List args = new LinkedList();

    /**
     * 値を生成して返却します。
     * 
     * @return 生成された値
     */
    protected Object generateValue() {

        final String methodName = getName();

        if (Eval.isBlank(methodName)) {
            throw new GinkgoException("name is blank." + methodName);
        }

        ArgumentsDesc argsDesc = new ArgumentsDesc((ArgumentDesc[]) args.toArray(new ArgumentDesc[0]));
        return new MethodDesc(methodName, argsDesc, MethodDesc.METHOD);
    }

    /**
     * エレメントを追加します。
     * 
     * @param arg
     *            エレメント
     */
    public void addElementTransferValue(ArgumentDesc arg) {
        args.add(arg);
    }

}
