/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.ginkgo.tags.core.beans;

import java.util.LinkedList;

import shohaku.core.beans.dynamic.ClassDesc;
import shohaku.core.beans.dynamic.FactoryMethodDesc;
import shohaku.core.beans.dynamic.MethodDesc;
import shohaku.core.lang.IntrospectionBeansException;
import shohaku.ginkgo.GinkgoException;
import shohaku.ginkgo.tags.AbstractValueTag;

/**
 * オブジェクトを生成する汎用の値タグを提供します。
 */
public class ObjectTag extends AbstractValueTag {

    private Class clazz = Object.class;

    private ClassDesc classDesc = new ClassDesc();

    private LinkedList initMethods = new LinkedList();

    /**
     * 値を生成して返却します。
     * 
     * @return 生成された値
     */
    protected Object generateValue() {

        if (clazz == null) {
            throw new GinkgoException("clazz is empty.");
        }

        if (!initMethods.isEmpty()) {
            MethodDesc[] es = (MethodDesc[]) initMethods.toArray(new MethodDesc[initMethods.size()]);
            classDesc.setInitMethods(es);
        }

        // new instance
        try {
            return classDesc.createInstance(clazz);
        } catch (IntrospectionBeansException e) {
            throw new GinkgoException("object create error. " + clazz, e);
        }
    }

    /**
     * クラスを格納します。
     * 
     * @param clazz
     *            クラス
     */
    public void setClazz(Class clazz) {
        this.clazz = clazz;
    }

    /**
     * clazz 属性を返却します。
     * 
     * @return clazz 属性
     */
    public Class getClazz() {
        return this.clazz;
    }

    /**
     * 初期化メソッドを追加します。
     * 
     * @param arg
     *            初期化メソッド
     */
    public void addElementTransferValue(MethodDesc arg) {
        initMethods.add(arg);
    }

    /**
     * ファクトリメソッドを追加します。<br>
     * 単一データのため２度呼ばれた場合は GinkgoException を発生します。
     * 
     * @param arg
     *            ファクトリメソッド
     */
    public void addElementTransferValue(FactoryMethodDesc arg) {
        if (classDesc.getFactory() != null) {
            throw new GinkgoException("FactoryMethodDesc except for one is illegal. " + arg);
        }
        classDesc.setFactory(arg);
    }

}
