/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.ginkgo.tags.core.collections;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import shohaku.core.lang.Eval;
import shohaku.ginkgo.GinkgoException;
import shohaku.ginkgo.tags.AbstractValueTag;

/**
 * 配列型のデータを生成する値タグを提供します。
 */
public class ArrayTag extends AbstractValueTag {

    private Class type = null;

    private final List elements = new LinkedList();

    /**
     * 値を生成して返却します。
     * 
     * @return 生成された値
     */
    protected Object generateValue() {

        if (type == null) {
            throw new GinkgoException("type is empty.");
        }

        if (!Eval.isArrayClass(type)) {
            throw new GinkgoException("no Array class. " + type.getClass());
        }

        // List args = getTagContext().getValueElementChildren();

        Object array;
        int index = 0;
        try {
            array = Array.newInstance(type.getComponentType(), elements.size());
            for (Iterator i = elements.iterator(); i.hasNext();) {
                Array.set(array, index, i.next());
                index++;
            }

        } catch (IllegalArgumentException e) {
            throw new GinkgoException("Illegal Array element type. " + type.getClass() + ", " + elements.get(index), e);
        }

        return array;
    }

    /**
     * type 属性を格納します。
     * 
     * @param type
     *            type属性
     */
    public void setType(Class type) {
        this.type = type;
    }

    /**
     * type 属性を返却します。
     * 
     * @return type 属性
     */
    public Class getType() {
        return this.type;
    }

    /**
     * エレメントを追加します。
     * 
     * @param element
     *            エレメント
     */
    public void addElementTransferValue(Object element) {
        elements.add(element);
    }
}
