/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.ginkgo.tags.core.collections;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import shohaku.core.lang.ObjectCreationException;
import shohaku.core.lang.feature.FeatureFactory;
import shohaku.ginkgo.GinkgoException;
import shohaku.ginkgo.tags.AbstractValueTag;

/**
 * マップ型のデータを生成する値タグを提供します。
 */
public class MapTag extends AbstractValueTag {

    private Class type = LinkedHashMap.class;

    private final List elements = new LinkedList();

    /**
     * 値を生成して返却します。
     * 
     * @return 生成された値
     */
    protected Object generateValue() {

        Map m;
        try {
            m = (Map) FeatureFactory.getLoader().getInstance(type);
        } catch (ClassCastException e) {
            throw new GinkgoException("class name which is not a Map class is specified. " + type, e);
        } catch (ObjectCreationException e) {
            throw new GinkgoException("illegal class name is specified. " + type, e);
        }

        for (Iterator i = elements.iterator(); i.hasNext();) {
            m.putAll((Map) i.next());
        }

        return Collections.unmodifiableMap(m);
    }

    /**
     * type 属性を格納します。
     * 
     * @param type
     *            type属性
     */
    public void setType(Class type) {
        this.type = type;
    }

    /**
     * type 属性を返却します。
     * 
     * @return type 属性
     */
    public Class getType() {
        return this.type;
    }

    /**
     * エレメントを追加します。
     * 
     * @param element
     *            エレメント
     */
    public void addElementTransferValue(Map element) {
        elements.add(element);
    }

}
