/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.ginkgo.tags.core.context;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import shohaku.core.helpers.HBeans;
import shohaku.core.lang.IntrospectionBeansException;
import shohaku.ginkgo.GinkgoException;
import shohaku.ginkgo.tags.AbstractContextTag;

/**
 * クラスの全ての定数フィールド（パブリックで有り、静的、ファイナルなフィールド）をコンテキスト属性に格納するタグを提供します。
 */
public class IncludeConstantFieldsTag extends AbstractContextTag {

    private Class clazz = null;

    private final List elements = new LinkedList();

    /**
     * 値を生成して返却します。
     * 
     * @return 生成された値
     */
    protected Object execute() {
        if (null == clazz && elements.isEmpty()) {
            throw new GinkgoException("class doesn't exist.");
        }
        try {
            Map constants = new HashMap();
            if (null != clazz) {
                constants.putAll(HBeans.getConstantFieldMap(clazz));
            }
            for (Iterator i = elements.iterator(); i.hasNext();) {
                constants.putAll(HBeans.getConstantFieldMap((Class) i.next()));
            }
            getTagContext().getDocumentContext().setAttributeAll(constants);
        } catch (IntrospectionBeansException e) {
            throw new GinkgoException("field access error.", e);
        }
        return null;
    }

    /**
     * class 属性を格納します。
     * 
     * @param clazz
     *            class属性
     */
    public void setClazz(Class clazz) {
        this.clazz = clazz;
    }

    /**
     * clazz 属性を返却します。
     * 
     * @return clazz 属性
     */
    public Class getClazz() {
        return this.clazz;
    }

    /**
     * エレメントを追加します。
     * 
     * @param element
     *            エレメント
     */
    public void addElementTransferValue(Class element) {
        elements.add(element);
    }

}