/*
 * shohaku
 * Copyright (C) 2006  tomoya nagatani
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
package shohaku.ginkgo.tags.core.context;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import shohaku.ginkgo.GinkgoException;
import shohaku.ginkgo.tags.AbstractContextTag;

/**
 * プロパティセットをコンテキスト属性に格納するタグを提供します。
 */
public class IncludePropertiesTag extends AbstractContextTag {

    /* プロパティセット */
    private Properties resource = null;

    private final List elements = new LinkedList();

    protected Object execute() {
        if (null == resource && elements.isEmpty()) {
            throw new GinkgoException("resource is null.");
        }
        Properties props = new Properties();
        if (null != resource) {
            props.putAll(resource);
        }
        for (Iterator i = elements.iterator(); i.hasNext();) {
            props.putAll((Map) i.next());
        }
        getTagContext().getDocumentContext().setAttributeAll(props);
        return null;
    }

    /**
     * プロパティセット属性を格納します。
     * 
     * @param resource
     *            プロパティセット
     */
    public void setResource(Properties resource) {
        this.resource = resource;
    }

    /**
     * プロパティセット属性を格納します。
     * 
     * @return プロパティセット
     */
    public Properties getResource() {
        return this.resource;
    }

    /**
     * エレメントを返却します。
     * 
     * @param element
     *            エレメント
     */
    public void addElementTransferValue(Map element) {
        elements.add(element);
    }

}
